/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteTypeDescriptor
extends AbstractTypeDescriptor<Byte> {
    public static final ByteTypeDescriptor INSTANCE = new ByteTypeDescriptor();

    public ByteTypeDescriptor() {
        super(Byte.class);
    }

    @Override
    public String toString(Byte by) {
        return Integer.toHexString(by - -128);
    }

    @Override
    public Byte fromString(String string) {
        return (byte)(Integer.parseInt(string, 16) + -128);
    }

    @Override
    public <X> X unwrap(Byte by, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (by == null) {
            return null;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)by;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf(by.shortValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)Integer.valueOf(by.intValue());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(by.longValue());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)Double.valueOf(by.doubleValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)Float.valueOf(by.floatValue());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)by.toString();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Byte wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Byte.class.isInstance(x)) {
            return (Byte)x;
        }
        if (Number.class.isInstance(x)) {
            return ((Number)x).byteValue();
        }
        if (String.class.isInstance(x)) {
            return Byte.valueOf((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

