/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.cfg.Environment;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarTypeDescriptor;
import org.hibernate.type.descriptor.java.DateTypeDescriptor;
import org.hibernate.util.CalendarComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarDateTypeDescriptor
extends AbstractTypeDescriptor<Calendar> {
    public static final CalendarDateTypeDescriptor INSTANCE = new CalendarDateTypeDescriptor();

    protected CalendarDateTypeDescriptor() {
        super(Calendar.class, CalendarTypeDescriptor.CalendarMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Calendar calendar) {
        return DateTypeDescriptor.INSTANCE.toString(calendar.getTime());
    }

    @Override
    public Calendar fromString(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(DateTypeDescriptor.INSTANCE.fromString(string));
        return gregorianCalendar;
    }

    @Override
    public boolean areEqual(Calendar calendar, Calendar calendar2) {
        if (calendar == calendar2) {
            return true;
        }
        if (calendar == null || calendar2 == null) {
            return false;
        }
        return calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    @Override
    public int extractHashCode(Calendar calendar) {
        int n = 1;
        n = 31 * n + calendar.get(5);
        n = 31 * n + calendar.get(2);
        n = 31 * n + calendar.get(1);
        return n;
    }

    @Override
    public Comparator<Calendar> getComparator() {
        return CalendarComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(Calendar calendar, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (calendar == null) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return (X)calendar;
        }
        if (java.sql.Date.class.isAssignableFrom(clazz)) {
            return (X)new java.sql.Date(calendar.getTimeInMillis());
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return (X)new Time(calendar.getTimeInMillis());
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return (X)new Timestamp(calendar.getTimeInMillis());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (X)new Date(calendar.getTimeInMillis());
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Calendar wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Calendar.class.isInstance(x)) {
            return (Calendar)x;
        }
        if (!Date.class.isInstance(x)) {
            throw this.unknownWrap(x.getClass());
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (Environment.jvmHasTimestampBug()) {
            long l = ((Date)x).getTime();
            long l2 = Timestamp.class.isInstance(x) ? (long)((Timestamp)x).getNanos() : 0L;
            gregorianCalendar.setTime(new Date(l + l2 / 1000000L));
        } else {
            gregorianCalendar.setTime((Date)x);
        }
        return gregorianCalendar;
    }
}

