/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.util.Currency;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrencyTypeDescriptor
extends AbstractTypeDescriptor<Currency> {
    public static final CurrencyTypeDescriptor INSTANCE = new CurrencyTypeDescriptor();

    public CurrencyTypeDescriptor() {
        super(Currency.class);
    }

    @Override
    public String toString(Currency currency) {
        return currency.getCurrencyCode();
    }

    @Override
    public Currency fromString(String string) {
        return Currency.getInstance(string);
    }

    @Override
    public <X> X unwrap(Currency currency, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (currency == null) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)currency.getCurrencyCode();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Currency wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (String.class.isInstance(x)) {
            return Currency.getInstance((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

