/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.BinaryStream;
import org.hibernate.type.descriptor.java.BinaryStreamImpl;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHelper {
    private static final Logger log = LoggerFactory.getLogger(DataHelper.class);
    private static Class nClobClass;

    public static boolean isNClob(Class clazz) {
        return nClobClass != null && nClobClass.isAssignableFrom(clazz);
    }

    public static String extractString(Reader reader) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            char[] cArray = new char[2048];
            while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading text", iOException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                log.warn("IOException occurred closing stream", iOException);
            }
        }
        return stringBuilder.toString();
    }

    private static String extractString(Reader reader, long l, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        try {
            int n2;
            long l2 = reader.skip(l - 1L);
            if (l2 != l - 1L) {
                throw new HibernateException("Unable to skip needed bytes");
            }
            char[] cArray = new char[2048];
            int n3 = 0;
            while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
                stringBuilder.append(cArray, 0, n2);
                if (n2 >= cArray.length && (n3 += n2) < n) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading a binary value", iOException);
        }
        return stringBuilder.toString();
    }

    public static Object subStream(Reader reader, long l, int n) {
        return new StringReader(DataHelper.extractString(reader, l, n));
    }

    public static byte[] extractBytes(InputStream inputStream) {
        if (BinaryStream.class.isInstance(inputStream)) {
            return ((BinaryStream)((Object)inputStream)).getBytes();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            int n;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading a binary value", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                log.warn("IOException occurred closing input stream", iOException);
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                log.warn("IOException occurred closing output stream", iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] extractBytes(InputStream inputStream, long l, int n) {
        if (BinaryStream.class.isInstance(inputStream) && Integer.MAX_VALUE > l) {
            byte[] byArray = ((BinaryStream)((Object)inputStream)).getBytes();
            int n2 = Math.min(n, byArray.length);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, (int)l, byArray2, 0, n2);
            return byArray2;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            int n3;
            long l2 = inputStream.skip(l - 1L);
            if (l2 != l - 1L) {
                throw new HibernateException("Unable to skip needed bytes");
            }
            byte[] byArray = new byte[2048];
            int n4 = 0;
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
                if (n3 >= byArray.length && (n4 += n3) < n) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new HibernateException("IOException occurred reading a binary value", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static InputStream subStream(InputStream inputStream, long l, int n) {
        return new BinaryStreamImpl(DataHelper.extractBytes(inputStream, l, n));
    }

    static {
        try {
            nClobClass = ReflectHelper.classForName("java.sql.NClob", DataHelper.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.info("Could not locate 'java.sql.NClob' class; assuming JDBC 3");
        }
    }
}

