/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatTypeDescriptor
extends AbstractTypeDescriptor<Float> {
    public static final FloatTypeDescriptor INSTANCE = new FloatTypeDescriptor();

    public FloatTypeDescriptor() {
        super(Float.class);
    }

    @Override
    public String toString(Float f) {
        return f == null ? null : f.toString();
    }

    @Override
    public Float fromString(String string) {
        return Float.valueOf(string);
    }

    @Override
    public <X> X unwrap(Float f, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (f == null) {
            return null;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)f;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)Byte.valueOf(f.byteValue());
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)Short.valueOf(f.shortValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)Integer.valueOf(f.intValue());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(f.longValue());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)Double.valueOf(f.doubleValue());
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return (X)BigInteger.valueOf(f.longValue());
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (X)BigDecimal.valueOf(f.floatValue());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)f.toString();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Float wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Float.class.isInstance(x)) {
            return (Float)x;
        }
        if (Number.class.isInstance(x)) {
            return Float.valueOf(((Number)x).floatValue());
        }
        if (String.class.isInstance(x)) {
            return Float.valueOf((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

