/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDateTypeDescriptor
extends AbstractTypeDescriptor<Date> {
    public static final JdbcDateTypeDescriptor INSTANCE = new JdbcDateTypeDescriptor();
    public static final String DATE_FORMAT = "dd MMMM yyyy";

    public JdbcDateTypeDescriptor() {
        super(Date.class, DateMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    @Override
    public Date fromString(String string) {
        try {
            return new Date(new SimpleDateFormat(DATE_FORMAT).parse(string).getTime());
        }
        catch (ParseException parseException) {
            throw new HibernateException("could not parse date string" + string, parseException);
        }
    }

    @Override
    public boolean areEqual(Date date, Date date2) {
        if (date == date2) {
            return true;
        }
        if (date == null || date2 == null) {
            return false;
        }
        if (date.getTime() == date2.getTime()) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return calendar.get(2) == calendar2.get(2) && calendar.get(5) == calendar2.get(5) && calendar.get(1) == calendar2.get(1);
    }

    @Override
    public int extractHashCode(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = 1;
        n = 31 * n + calendar.get(2);
        n = 31 * n + calendar.get(5);
        n = 31 * n + calendar.get(1);
        return n;
    }

    @Override
    public <X> X unwrap(Date date, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (date == null) {
            return null;
        }
        if (java.sql.Date.class.isAssignableFrom(clazz)) {
            java.sql.Date date2 = java.sql.Date.class.isInstance(date) ? (java.sql.Date)date : new java.sql.Date(date.getTime());
            return (X)date2;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            Time time = Time.class.isInstance(date) ? (Time)date : new Time(date.getTime());
            return (X)time;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            Timestamp timestamp = Timestamp.class.isInstance(date) ? (Timestamp)date : new Timestamp(date.getTime());
            return (X)timestamp;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (X)date;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(date.getTime());
            return (X)gregorianCalendar;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(date.getTime());
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Date wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Date.class.isInstance(x)) {
            return (Date)x;
        }
        if (Long.class.isInstance(x)) {
            return new java.sql.Date((Long)x);
        }
        if (Calendar.class.isInstance(x)) {
            return new java.sql.Date(((Calendar)x).getTimeInMillis());
        }
        if (Date.class.isInstance(x)) {
            return new java.sql.Date(((Date)x).getTime());
        }
        throw this.unknownWrap(x.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateMutabilityPlan
    extends MutableMutabilityPlan<Date> {
        public static final DateMutabilityPlan INSTANCE = new DateMutabilityPlan();

        @Override
        public Date deepCopyNotNull(Date date) {
            return java.sql.Date.class.isInstance(date) ? new java.sql.Date(date.getTime()) : new Date(date.getTime());
        }
    }
}

