/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleTypeDescriptor
extends AbstractTypeDescriptor<Locale> {
    public static final LocaleTypeDescriptor INSTANCE = new LocaleTypeDescriptor();

    public LocaleTypeDescriptor() {
        super(Locale.class);
    }

    @Override
    public Comparator<Locale> getComparator() {
        return LocaleComparator.INSTANCE;
    }

    @Override
    public String toString(Locale locale) {
        return locale.toString();
    }

    @Override
    public Locale fromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        String string4 = "";
        String string5 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string5 + stringTokenizer.nextToken();
            string5 = "_";
        }
        return new Locale(string2, string3, string4);
    }

    @Override
    public <X> X unwrap(Locale locale, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (locale == null) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)locale.toString();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Locale wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (String.class.isInstance(x)) {
            return this.fromString((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocaleComparator
    implements Comparator<Locale> {
        public static final LocaleComparator INSTANCE = new LocaleComparator();

        @Override
        public int compare(Locale locale, Locale locale2) {
            return locale.toString().compareTo(locale2.toString());
        }
    }
}

