/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.CharacterStream;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.ArrayMutabilityPlan;
import org.hibernate.type.descriptor.java.CharacterStreamImpl;
import org.hibernate.type.descriptor.java.DataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveCharacterArrayTypeDescriptor
extends AbstractTypeDescriptor<char[]> {
    public static final PrimitiveCharacterArrayTypeDescriptor INSTANCE = new PrimitiveCharacterArrayTypeDescriptor();

    protected PrimitiveCharacterArrayTypeDescriptor() {
        super(char[].class, ArrayMutabilityPlan.INSTANCE);
    }

    @Override
    public String toString(char[] cArray) {
        return new String(cArray);
    }

    @Override
    public char[] fromString(String string) {
        return string.toCharArray();
    }

    @Override
    public boolean areEqual(char[] cArray, char[] cArray2) {
        return cArray == cArray2 || cArray != null && cArray2 != null && Arrays.equals(cArray, cArray2);
    }

    @Override
    public int extractHashCode(char[] cArray) {
        int n = 1;
        for (char c : cArray) {
            n = 31 * n + c;
        }
        return n;
    }

    @Override
    public <X> X unwrap(char[] cArray, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (cArray == null) {
            return null;
        }
        if (char[].class.isAssignableFrom(clazz)) {
            return (X)cArray;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)new String(cArray);
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return (X)wrapperOptions.getLobCreator().createClob(new String(cArray));
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return (X)new StringReader(new String(cArray));
        }
        if (CharacterStream.class.isAssignableFrom(clazz)) {
            return (X)new CharacterStreamImpl(new String(cArray));
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> char[] wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (char[].class.isInstance(x)) {
            return (char[])x;
        }
        if (String.class.isInstance(x)) {
            return ((String)x).toCharArray();
        }
        if (Clob.class.isInstance(x)) {
            try {
                return DataHelper.extractString(((Clob)x).getCharacterStream()).toCharArray();
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Unable to access lob stream", sQLException);
            }
        }
        if (Reader.class.isInstance(x)) {
            return DataHelper.extractString((Reader)x).toCharArray();
        }
        throw this.unknownWrap(x.getClass());
    }
}

