/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortTypeDescriptor
extends AbstractTypeDescriptor<Short> {
    public static final ShortTypeDescriptor INSTANCE = new ShortTypeDescriptor();

    public ShortTypeDescriptor() {
        super(Short.class);
    }

    @Override
    public String toString(Short s) {
        return s == null ? null : s.toString();
    }

    @Override
    public Short fromString(String string) {
        return Short.valueOf(string);
    }

    @Override
    public <X> X unwrap(Short s, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (s == null) {
            return null;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (X)s;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (X)Byte.valueOf(s.byteValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (X)Integer.valueOf(s.intValue());
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (X)Long.valueOf(s.longValue());
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (X)Double.valueOf(s.doubleValue());
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (X)Float.valueOf(s.floatValue());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)s.toString();
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> Short wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (Short.class.isInstance(x)) {
            return (Short)x;
        }
        if (Number.class.isInstance(x)) {
            return ((Number)x).shortValue();
        }
        if (String.class.isInstance(x)) {
            return Short.valueOf((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

