/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.CharacterStream;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.CharacterStreamImpl;
import org.hibernate.type.descriptor.java.DataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTypeDescriptor
extends AbstractTypeDescriptor<String> {
    public static final StringTypeDescriptor INSTANCE = new StringTypeDescriptor();

    public StringTypeDescriptor() {
        super(String.class);
    }

    @Override
    public String toString(String string) {
        return string;
    }

    @Override
    public String fromString(String string) {
        return string;
    }

    @Override
    public <X> X unwrap(String string, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (string == null) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)string;
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return (X)new StringReader(string);
        }
        if (CharacterStream.class.isAssignableFrom(clazz)) {
            return (X)new CharacterStreamImpl(string);
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return (X)wrapperOptions.getLobCreator().createClob(string);
        }
        if (DataHelper.isNClob(clazz)) {
            return (X)wrapperOptions.getLobCreator().createNClob(string);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> String wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (String.class.isInstance(x)) {
            return (String)x;
        }
        if (Reader.class.isInstance(x)) {
            return DataHelper.extractString((Reader)x);
        }
        if (Clob.class.isInstance(x) || DataHelper.isNClob(x.getClass())) {
            try {
                return DataHelper.extractString(((Clob)x).getCharacterStream());
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Unable to access lob stream", sQLException);
            }
        }
        throw this.unknownWrap(x.getClass());
    }
}

