/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.net.MalformedURLException;
import java.net.URL;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlTypeDescriptor
extends AbstractTypeDescriptor<URL> {
    public static final UrlTypeDescriptor INSTANCE = new UrlTypeDescriptor();

    public UrlTypeDescriptor() {
        super(URL.class);
    }

    @Override
    public String toString(URL uRL) {
        return uRL.toExternalForm();
    }

    @Override
    public URL fromString(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HibernateException("Unable to convert string [" + string + "] to URL : " + malformedURLException);
        }
    }

    @Override
    public <X> X unwrap(URL uRL, Class<X> clazz, WrapperOptions wrapperOptions) {
        if (uRL == null) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (X)this.toString(uRL);
        }
        throw this.unknownUnwrap(clazz);
    }

    @Override
    public <X> URL wrap(X x, WrapperOptions wrapperOptions) {
        if (x == null) {
            return null;
        }
        if (String.class.isInstance(x)) {
            return this.fromString((String)x);
        }
        throw this.unknownWrap(x.getClass());
    }
}

