/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicBinder<J>
implements ValueBinder<J> {
    private static final Logger log = LoggerFactory.getLogger(BasicBinder.class);
    private static final String BIND_MSG_TEMPLATE = "binding parameter [%d] as [%s] - %s";
    private static final String NULL_BIND_MSG_TEMPLATE = "binding parameter [%d] as [%s] - <null>";
    private final JavaTypeDescriptor<J> javaDescriptor;
    private final SqlTypeDescriptor sqlDescriptor;

    public JavaTypeDescriptor<J> getJavaDescriptor() {
        return this.javaDescriptor;
    }

    public SqlTypeDescriptor getSqlDescriptor() {
        return this.sqlDescriptor;
    }

    public BasicBinder(JavaTypeDescriptor<J> javaTypeDescriptor, SqlTypeDescriptor sqlTypeDescriptor) {
        this.javaDescriptor = javaTypeDescriptor;
        this.sqlDescriptor = sqlTypeDescriptor;
    }

    @Override
    public final void bind(PreparedStatement preparedStatement, J j, int n, WrapperOptions wrapperOptions) throws SQLException {
        if (j == null) {
            if (log.isTraceEnabled()) {
                log.trace(String.format(NULL_BIND_MSG_TEMPLATE, n, JdbcTypeNameMapper.getTypeName(this.sqlDescriptor.getSqlType())));
            }
            preparedStatement.setNull(n, this.sqlDescriptor.getSqlType());
        } else {
            log.trace(String.format(BIND_MSG_TEMPLATE, n, JdbcTypeNameMapper.getTypeName(this.sqlDescriptor.getSqlType()), this.getJavaDescriptor().extractLoggableRepresentation(j)));
            this.doBind(preparedStatement, j, n, wrapperOptions);
        }
    }

    protected abstract void doBind(PreparedStatement var1, J var2, int var3, WrapperOptions var4) throws SQLException;
}

