/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionHelper {
    public static final int MINIMUM_INITIAL_CAPACITY = 16;
    public static final float LOAD_FACTOR = 0.75f;
    public static final List EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    public static final Collection EMPTY_COLLECTION = Collections.unmodifiableCollection(new ArrayList(0));
    public static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));

    private CollectionHelper() {
    }

    public static Map mapOfSize(int n) {
        return new HashMap(CollectionHelper.determineProperSizing(n), 0.75f);
    }

    public static int determineProperSizing(Map map) {
        return CollectionHelper.determineProperSizing(map.size());
    }

    public static int determineProperSizing(Set set) {
        return CollectionHelper.determineProperSizing(set.size());
    }

    public static int determineProperSizing(int n) {
        int n2 = (int)((float)n / 0.75f) + 1;
        return Math.max(n2, 16);
    }
}

