/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.InputStream;
import java.io.Serializable;
import org.hibernate.util.ConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DTDEntityResolver.class);
    private static final String HIBERNATE_NAMESPACE = "http://www.hibernate.org/dtd/";
    private static final String OLD_HIBERNATE_NAMESPACE = "http://hibernate.sourceforge.net/";
    private static final String USER_NAMESPACE = "classpath://";

    public InputSource resolveEntity(String string, String string2) {
        InputSource inputSource = null;
        if (string2 != null) {
            log.debug("trying to resolve system-id [" + string2 + "]");
            if (string2.startsWith(HIBERNATE_NAMESPACE)) {
                log.debug("recognized hibernate namespace; attempting to resolve on classpath under org/hibernate/");
                inputSource = this.resolveOnClassPath(string, string2, HIBERNATE_NAMESPACE);
            } else if (string2.startsWith(OLD_HIBERNATE_NAMESPACE)) {
                log.warn("recognized obsolete hibernate namespace http://hibernate.sourceforge.net/. Use namespace http://www.hibernate.org/dtd/ instead. Refer to Hibernate 3.6 Migration Guide!");
                log.debug("attempting to resolve on classpath under org/hibernate/");
                inputSource = this.resolveOnClassPath(string, string2, OLD_HIBERNATE_NAMESPACE);
            } else if (string2.startsWith(USER_NAMESPACE)) {
                log.debug("recognized local namespace; attempting to resolve on classpath");
                String string3 = string2.substring(USER_NAMESPACE.length());
                InputStream inputStream = this.resolveInLocalNamespace(string3);
                if (inputStream == null) {
                    log.debug("unable to locate [" + string2 + "] on classpath");
                } else {
                    log.debug("located [" + string2 + "] in classpath");
                    inputSource = new InputSource(inputStream);
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                }
            }
        }
        return inputSource;
    }

    private InputSource resolveOnClassPath(String string, String string2, String string3) {
        InputSource inputSource = null;
        String string4 = "org/hibernate/" + string2.substring(string3.length());
        InputStream inputStream = this.resolveInHibernateNamespace(string4);
        if (inputStream == null) {
            log.debug("unable to locate [" + string2 + "] on classpath");
            if (string2.substring(string3.length()).indexOf("2.0") > -1) {
                log.error("Don't use old DTDs, read the Hibernate 3.x Migration Guide!");
            }
        } else {
            log.debug("located [" + string2 + "] in classpath");
            inputSource = new InputSource(inputStream);
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
        }
        return inputSource;
    }

    protected InputStream resolveInHibernateNamespace(String string) {
        return this.getClass().getClassLoader().getResourceAsStream(string);
    }

    protected InputStream resolveInLocalNamespace(String string) {
        try {
            return ConfigHelper.getUserResourceAsStream(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

