/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.sql.Template;
import org.hibernate.util.StringHelper;

public class FilterHelper {
    private final String[] filterNames;
    private final String[] filterConditions;

    public FilterHelper(Map map, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        int n = map.size();
        this.filterNames = new String[n];
        this.filterConditions = new String[n];
        Iterator iterator = map.entrySet().iterator();
        n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.filterNames[n] = (String)entry.getKey();
            this.filterConditions[n] = Template.renderWhereStringTemplate((String)entry.getValue(), "$FILTER_PLACEHOLDER$", dialect, sQLFunctionRegistry);
            this.filterConditions[n] = StringHelper.replace(this.filterConditions[n], ":", ":" + this.filterNames[n] + ".");
            ++n;
        }
    }

    public boolean isAffectedBy(Map map) {
        int n = this.filterNames.length;
        for (int i = 0; i < n; ++i) {
            if (!map.containsKey(this.filterNames[i])) continue;
            return true;
        }
        return false;
    }

    public String render(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        this.render(stringBuffer, string, map);
        return stringBuffer.toString();
    }

    public void render(StringBuffer stringBuffer, String string, Map map) {
        if (this.filterNames != null && this.filterNames.length > 0) {
            int n = this.filterNames.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                if (!map.containsKey(this.filterNames[i]) || !StringHelper.isNotEmpty(string2 = this.filterConditions[i])) continue;
                stringBuffer.append(" and ").append(StringHelper.replace(string2, "$FILTER_PLACEHOLDER$", string));
            }
        }
    }
}

