/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCExceptionReporter {
    public static final Logger log = LoggerFactory.getLogger(JDBCExceptionReporter.class);
    public static final String DEFAULT_EXCEPTION_MSG = "SQL Exception";
    public static final String DEFAULT_WARNING_MSG = "SQL Warning";
    public static StandardWarningHandler STANDARD_WARNING_HANDLER = new StandardWarningHandler("SQL Warning");

    private JDBCExceptionReporter() {
    }

    public static void logAndClearWarnings(Connection connection) {
        JDBCExceptionReporter.handleAndClearWarnings(connection, (WarningHandler)STANDARD_WARNING_HANDLER);
    }

    public static void handleAndClearWarnings(Connection connection, WarningHandler warningHandler) {
        try {
            JDBCExceptionReporter.walkWarnings(connection.getWarnings(), warningHandler);
        }
        catch (SQLException sQLException) {
            log.debug("could not log warnings", sQLException);
        }
        try {
            connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            log.debug("could not clear warnings", sQLException);
        }
    }

    public static void handleAndClearWarnings(Statement statement, WarningHandler warningHandler) {
        try {
            JDBCExceptionReporter.walkWarnings(statement.getWarnings(), warningHandler);
        }
        catch (SQLException sQLException) {
            log.debug("could not log warnings", sQLException);
        }
        try {
            statement.clearWarnings();
        }
        catch (SQLException sQLException) {
            log.debug("could not clear warnings", sQLException);
        }
    }

    @Deprecated
    public static void logWarnings(SQLWarning sQLWarning) {
        JDBCExceptionReporter.walkWarnings(sQLWarning, STANDARD_WARNING_HANDLER);
    }

    @Deprecated
    public static void logWarnings(SQLWarning sQLWarning, String string) {
        StandardWarningHandler standardWarningHandler = StringHelper.isNotEmpty(string) ? new StandardWarningHandler(string) : STANDARD_WARNING_HANDLER;
        JDBCExceptionReporter.walkWarnings(sQLWarning, standardWarningHandler);
    }

    public static void walkWarnings(SQLWarning sQLWarning, WarningHandler warningHandler) {
        if (sQLWarning == null || warningHandler.doProcess()) {
            return;
        }
        warningHandler.prepare(sQLWarning);
        while (sQLWarning != null) {
            warningHandler.handleWarning(sQLWarning);
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void logExceptions(SQLException sQLException) {
        JDBCExceptionReporter.logExceptions(sQLException, null);
    }

    public static void logExceptions(SQLException sQLException, String string) {
        if (log.isErrorEnabled()) {
            if (log.isDebugEnabled()) {
                string = StringHelper.isNotEmpty(string) ? string : DEFAULT_EXCEPTION_MSG;
                log.debug(string, sQLException);
            }
            while (sQLException != null) {
                StringBuffer stringBuffer = new StringBuffer(30).append("SQL Error: ").append(sQLException.getErrorCode()).append(", SQLState: ").append(sQLException.getSQLState());
                log.warn(stringBuffer.toString());
                log.error(sQLException.getMessage());
                sQLException = sQLException.getNextException();
            }
        }
    }

    public static class StandardWarningHandler
    extends WarningHandlerLoggingSupport {
        private final String introMessage;

        public StandardWarningHandler(String string) {
            this.introMessage = string;
        }

        public boolean doProcess() {
            return log.isWarnEnabled();
        }

        public void prepare(SQLWarning sQLWarning) {
            log.debug(this.introMessage, sQLWarning);
        }

        protected void logWarning(String string, String string2) {
            log.warn(string);
            log.warn(string2);
        }
    }

    public static abstract class WarningHandlerLoggingSupport
    implements WarningHandler {
        public final void handleWarning(SQLWarning sQLWarning) {
            StringBuffer stringBuffer = new StringBuffer(30).append("SQL Warning Code: ").append(sQLWarning.getErrorCode()).append(", SQLState: ").append(sQLWarning.getSQLState());
            this.logWarning(stringBuffer.toString(), sQLWarning.getMessage());
        }

        protected abstract void logWarning(String var1, String var2);
    }

    public static interface WarningHandler {
        public boolean doProcess();

        public void prepare(SQLWarning var1);

        public void handleWarning(SQLWarning var1);
    }
}

