/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionFactoryImplementor;

public final class JTAHelper {
    private JTAHelper() {
    }

    public static boolean isRollback(int n) {
        return n == 1 || n == 9 || n == 4;
    }

    public static boolean isInProgress(int n) {
        return n == 0 || n == 1;
    }

    public static boolean isTransactionInProgress(SessionFactoryImplementor sessionFactoryImplementor) {
        TransactionManager transactionManager = sessionFactoryImplementor.getTransactionManager();
        try {
            return transactionManager != null && JTAHelper.isTransactionInProgress(transactionManager.getTransaction());
        }
        catch (SystemException systemException) {
            throw new TransactionException("could not obtain JTA Transaction", systemException);
        }
    }

    public static boolean isTransactionInProgress(Transaction transaction) throws SystemException {
        return transaction != null && JTAHelper.isInProgress(transaction.getStatus());
    }

    public static boolean isMarkedForRollback(int n) {
        return n == 1;
    }

    public static boolean isMarkedForRollback(Transaction transaction) throws SystemException {
        return JTAHelper.isMarkedForRollback(transaction.getStatus());
    }
}

