/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamingHelper {
    private static final Logger log = LoggerFactory.getLogger(NamingHelper.class);

    public static InitialContext getInitialContext(Properties properties) throws NamingException {
        Properties properties2 = NamingHelper.getJndiProperties(properties);
        log.info("JNDI InitialContext properties:" + properties2);
        try {
            return ((Hashtable)properties2).size() == 0 ? new InitialContext() : new InitialContext(properties2);
        }
        catch (NamingException namingException) {
            log.error("Could not obtain initial context", namingException);
            throw namingException;
        }
    }

    public static void bind(Context context, String string, Object object) throws NamingException {
        try {
            log.trace("binding: " + string);
            context.rebind(string, object);
        }
        catch (Exception exception) {
            Name name = context.getNameParser("").parse(string);
            while (name.size() > 1) {
                String string2 = name.get(0);
                Context context2 = null;
                try {
                    log.trace("lookup: " + string2);
                    context2 = (Context)context.lookup(string2);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if (context2 != null) {
                    log.debug("Found subcontext: " + string2);
                    context = context2;
                } else {
                    log.info("Creating subcontext: " + string2);
                    context = context.createSubcontext(string2);
                }
                name = name.getSuffix(1);
            }
            log.trace("binding: " + name);
            context.rebind(name, object);
        }
        log.debug("Bound name: " + string);
    }

    public static Properties getJndiProperties(Properties properties) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("hibernate.jndi.class");
        hashSet.add("hibernate.jndi.url");
        Iterator<Object> iterator = properties.keySet().iterator();
        Properties properties2 = new Properties();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.indexOf("hibernate.jndi") <= -1 || hashSet.contains(string)) continue;
            properties2.setProperty(string.substring("hibernate.jndi".length() + 1), properties.getProperty(string));
        }
        string = properties.getProperty("hibernate.jndi.class");
        String string2 = properties.getProperty("hibernate.jndi.url");
        if (string != null) {
            properties2.put("java.naming.factory.initial", string);
        }
        if (string2 != null) {
            properties2.put("java.naming.provider.url", string2);
        }
        return properties2;
    }

    private NamingHelper() {
    }
}

