/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public final class PropertiesHelper {
    private static final String PLACEHOLDER_START = "${";

    private PropertiesHelper() {
    }

    public static String getString(String string, Properties properties, String string2) {
        String string3 = PropertiesHelper.extractPropertyValue(string, properties);
        return string3 == null ? string2 : string3;
    }

    public static String extractPropertyValue(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return null;
        }
        if (StringHelper.isEmpty(string2 = string2.trim())) {
            return null;
        }
        return string2;
    }

    public static boolean getBoolean(String string, Properties properties) {
        return PropertiesHelper.getBoolean(string, properties, false);
    }

    public static boolean getBoolean(String string, Properties properties, boolean bl) {
        String string2 = PropertiesHelper.extractPropertyValue(string, properties);
        return string2 == null ? bl : Boolean.valueOf(string2);
    }

    public static int getInt(String string, Properties properties, int n) {
        String string2 = PropertiesHelper.extractPropertyValue(string, properties);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public static Integer getInteger(String string, Properties properties) {
        String string2 = PropertiesHelper.extractPropertyValue(string, properties);
        return string2 == null ? null : Integer.valueOf(string2);
    }

    public static Map toMap(String string, String string2, Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = PropertiesHelper.extractPropertyValue(string, properties);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            while (stringTokenizer.hasMoreTokens()) {
                hashMap.put(stringTokenizer.nextToken(), stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : "");
            }
        }
        return hashMap;
    }

    public static String[] toStringArray(String string, String string2, Properties properties) {
        return PropertiesHelper.toStringArray(PropertiesHelper.extractPropertyValue(string, properties), string2);
    }

    public static String[] toStringArray(String string, String string2) {
        if (string != null) {
            return StringHelper.split(string2, string);
        }
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public static Properties maskOut(Properties properties, String string) {
        Properties properties2 = (Properties)properties.clone();
        if (properties2.get(string) != null) {
            properties2.setProperty(string, "****");
        }
        return properties2;
    }

    public static void resolvePlaceHolders(Properties properties) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry<Object, Object> entry = iterator.next();
            Object object = entry.getValue();
            if (object == null || !String.class.isInstance(object) || object.equals(string = PropertiesHelper.resolvePlaceHolder((String)object))) continue;
            if (string == null) {
                iterator.remove();
                continue;
            }
            entry.setValue(string);
        }
    }

    public static String resolvePlaceHolder(String string) {
        String string2;
        if (string.indexOf(PLACEHOLDER_START) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '$' && cArray[i + 1] == '{') {
                int n;
                String string3 = "";
                for (n = i + 2; n < cArray.length && cArray[n] != '}'; ++n) {
                    string3 = string3 + cArray[n];
                    if (n != cArray.length - 1) continue;
                    throw new IllegalArgumentException("unmatched placeholder start [" + string + "]");
                }
                String string4 = PropertiesHelper.extractFromSystem(string3);
                stringBuffer.append(string4 == null ? "" : string4);
                i = n + 1;
                if (i >= cArray.length) break;
            }
            stringBuffer.append(cArray[i]);
        }
        return StringHelper.isEmpty(string2 = stringBuffer.toString()) ? null : string2;
    }

    private static String extractFromSystem(String string) {
        try {
            return System.getProperty(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

