/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.collections.map.LRUMap;

public class SimpleMRUCache
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    private final int strongReferenceCount;
    private transient LRUMap cache;

    public SimpleMRUCache() {
        this(128);
    }

    public SimpleMRUCache(int n) {
        this.strongReferenceCount = n;
        this.init();
    }

    public synchronized Object get(Object object) {
        return this.cache.get(object);
    }

    public synchronized Object put(Object object, Object object2) {
        return this.cache.put(object, object2);
    }

    public synchronized int size() {
        return this.cache.size();
    }

    private void init() {
        this.cache = new LRUMap(this.strongReferenceCount);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

