/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.hibernate.util.LRUMap;

public class SoftLimitMRUCache
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    public static final int DEFAULT_SOFT_REF_COUNT = 2048;
    private final int strongRefCount;
    private final int softRefCount;
    private transient LRUMap strongRefCache;
    private transient LRUMap softRefCache;
    private transient ReferenceQueue referenceQueue;

    public SoftLimitMRUCache() {
        this(128, 2048);
    }

    public SoftLimitMRUCache(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Reference counts must be greater than zero");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Strong reference count cannot exceed soft reference count");
        }
        this.strongRefCount = n;
        this.softRefCount = n2;
        this.init();
    }

    public synchronized Object get(Object object) {
        Object t;
        if (object == null) {
            throw new NullPointerException("Key to get cannot be null");
        }
        this.clearObsoleteReferences();
        SoftReference softReference = (SoftReference)this.softRefCache.get(object);
        if (softReference != null && (t = softReference.get()) != null) {
            this.strongRefCache.put(object, t);
            return t;
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException(this.getClass().getName() + "does not support null key [" + object + "] or value [" + object2 + "]");
        }
        this.clearObsoleteReferences();
        this.strongRefCache.put(object, object2);
        SoftReference softReference = this.softRefCache.put(object, new KeyedSoftReference(object, object2, this.referenceQueue));
        return softReference != null ? softReference.get() : null;
    }

    public synchronized int size() {
        this.clearObsoleteReferences();
        return this.strongRefCache.size();
    }

    public synchronized int softSize() {
        this.clearObsoleteReferences();
        return this.softRefCache.size();
    }

    public synchronized void clear() {
        this.strongRefCache.clear();
        this.softRefCache.clear();
    }

    private void init() {
        this.strongRefCache = new LRUMap(this.strongRefCount);
        this.softRefCache = new LRUMap(this.softRefCount);
        this.referenceQueue = new ReferenceQueue();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void clearObsoleteReferences() {
        KeyedSoftReference keyedSoftReference;
        while ((keyedSoftReference = (KeyedSoftReference)this.referenceQueue.poll()) != null) {
            Object object = keyedSoftReference.getKey();
            this.softRefCache.remove(object);
        }
    }

    private static class KeyedSoftReference
    extends SoftReference {
        private final Object key;

        private KeyedSoftReference(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        private Object getKey() {
            return this.key;
        }
    }
}

