/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util.xml;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ErrorLogger
implements ErrorHandler,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogger.class);
    private SAXParseException error;

    public SAXParseException getError() {
        return this.error;
    }

    public void error(SAXParseException sAXParseException) {
        log.error("Error parsing XML (" + sAXParseException.getLineNumber() + ") : " + sAXParseException.getMessage());
        if (this.error == null) {
            this.error = sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.error(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        log.error("Warning parsing XML (" + this.error.getLineNumber() + ") : " + this.error.getMessage());
    }

    public void reset() {
        this.error = null;
    }
}

