/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util.xml;

import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.hibernate.InvalidMappingException;
import org.hibernate.util.xml.ErrorLogger;
import org.hibernate.util.xml.Origin;
import org.hibernate.util.xml.XmlDocument;
import org.hibernate.util.xml.XmlDocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MappingReader {
    private static final Logger log = LoggerFactory.getLogger(MappingReader.class);
    public static final String ASSUMED_ORM_XSD_VERSION = "2.0";
    public static final MappingReader INSTANCE = new MappingReader();

    private MappingReader() {
    }

    public XmlDocument readMappingDocument(EntityResolver entityResolver, InputSource inputSource, Origin origin) {
        ErrorLogger errorLogger = new ErrorLogger();
        SAXReader sAXReader = new SAXReader();
        sAXReader.setEntityResolver(entityResolver);
        sAXReader.setErrorHandler(errorLogger);
        sAXReader.setMergeAdjacentText(true);
        sAXReader.setValidation(true);
        Document document = null;
        try {
            this.setValidationFor(sAXReader, "orm_2_0.xsd");
            document = sAXReader.read(inputSource);
            if (errorLogger.getError() != null) {
                throw errorLogger.getError();
            }
            return new XmlDocumentImpl(document, origin.getType(), origin.getName());
        }
        catch (Exception exception) {
            log.debug("Problem parsing XML using orm 2 xsd : {}", (Object)exception.getMessage());
            Exception exception2 = exception;
            errorLogger.reset();
            if (document != null) {
                try {
                    this.setValidationFor(sAXReader, "orm_1_0.xsd");
                    document = sAXReader.read(new StringReader(document.asXML()));
                    if (errorLogger.getError() != null) {
                        throw errorLogger.getError();
                    }
                    return new XmlDocumentImpl(document, origin.getType(), origin.getName());
                }
                catch (Exception exception3) {
                    log.debug("Problem parsing XML using orm 1 xsd : {}", (Object)exception3.getMessage());
                }
            }
            throw new InvalidMappingException("Unable to read XML", origin.getType(), origin.getName(), exception2);
        }
    }

    private void setValidationFor(SAXReader sAXReader, String string) {
        try {
            sAXReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            sAXReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://java.sun.com/xml/ns/persistence/orm " + string);
        }
        catch (SAXException sAXException) {
            sAXReader.setValidation(false);
        }
    }
}

