/*
 * Decompiled with CFR 0.152.
 */
package org.orm;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.orm.PersistentException;
import org.orm.PersistentManager;
import org.orm.PersistentSession;
import org.orm.ermodel.ERModel;
import org.orm.ermodel.handler.ERModelHandler;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.DDLStatementCollection;

public class ORMDatabaseInitiator {
    private static Log log = LogFactory.getLog(ORMDatabaseInitiator.class);

    private ORMDatabaseInitiator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSchema(PersistentManager persistentManager) throws SQLException, PersistentException {
        ERModel eRModel = ORMDatabaseInitiator.loadERModel(persistentManager);
        DDLGenerator dDLGenerator = new DDLGenerator();
        DDLStatementCollection dDLStatementCollection = dDLGenerator.createSchema(eRModel, Dialect.getDialect(persistentManager.getConfiguration().getProperties()));
        PersistentSession persistentSession = persistentManager.getSession();
        try {
            Connection connection = persistentSession.connection();
            ORMDatabaseInitiator.executeStatements(dDLStatementCollection.getAllStatements(), connection);
        }
        finally {
            persistentSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropSchema(PersistentManager persistentManager) throws SQLException, PersistentException {
        ERModel eRModel = ORMDatabaseInitiator.loadERModel(persistentManager);
        DDLGenerator dDLGenerator = new DDLGenerator();
        String[] stringArray = dDLGenerator.dropSchema(eRModel, Dialect.getDialect(persistentManager.getConfiguration().getProperties())).getAllStatements();
        PersistentSession persistentSession = persistentManager.getSession();
        try {
            Connection connection = persistentSession.connection();
            ORMDatabaseInitiator.executeStatements(stringArray, connection);
        }
        finally {
            persistentSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSchema(PersistentManager persistentManager) throws SQLException, PersistentException {
        ERModel eRModel = ORMDatabaseInitiator.loadERModel(persistentManager);
        DDLGenerator dDLGenerator = new DDLGenerator();
        PersistentSession persistentSession = persistentManager.getSession();
        try {
            Connection connection = persistentSession.connection();
            Properties properties = persistentManager.getConfiguration().getProperties();
            String string = properties.getProperty("hibernate.connection.username");
            DDLStatementCollection dDLStatementCollection = dDLGenerator.updateSchema(eRModel, connection, Dialect.getDialect(properties), string, false, null);
            ORMDatabaseInitiator.executeStatements(dDLStatementCollection.getAllStatements(), connection);
        }
        finally {
            persistentSession.close();
        }
    }

    private static void executeStatements(String[] stringArray, Connection connection) throws SQLException {
        if (!connection.getAutoCommit()) {
            connection.commit();
            connection.setAutoCommit(true);
        }
        Statement statement = connection.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                log.debug("Executing: " + stringArray[i]);
                statement.executeUpdate(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                log.warn("Error executing script", exception);
            }
        }
        statement.close();
    }

    private static ERModel loadERModel(PersistentManager persistentManager) {
        ERModelHandler eRModelHandler = new ERModelHandler();
        ERModel eRModel = eRModelHandler.load("/ormmapping/" + persistentManager.getProjectName() + ".erd.xml");
        return eRModel;
    }
}

