/*
 * Decompiled with CFR 0.152.
 */
package org.orm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.FlushMode;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.util.DTDEntityResolver;
import org.orm.ORMInterceptor;
import org.orm.PersistentException;
import org.orm.PersistentSession;
import org.orm.PersistentTransaction;
import org.orm.cfg.JDBCConnectionSetting;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.util.AdvancedAppBaseSessionController;
import org.orm.util.AppBaseSessionController;
import org.orm.util.SessionController;
import org.orm.util.ThreadBaseSessionController;
import org.orm.util.UserDefinedSessionController;

public abstract class PersistentManager {
    private static Log log = LogFactory.getLog(PersistentManager.class);
    private SessionController _sessionController;
    private Configuration _cfg;
    private final SessionType _sessionType;
    private FlushMode _flushMode = null;
    private ORMInterceptor _interceptor;

    public abstract String getProjectName();

    protected PersistentManager(JDBCConnectionSetting jDBCConnectionSetting, SessionType sessionType, String[] stringArray) throws PersistentException {
        this(jDBCConnectionSetting, sessionType, 60000, stringArray);
    }

    protected PersistentManager(JDBCConnectionSetting jDBCConnectionSetting, SessionType sessionType, int n, String[] stringArray) throws PersistentException {
        this(jDBCConnectionSetting, sessionType, n, stringArray, null);
    }

    protected PersistentManager(JDBCConnectionSetting jDBCConnectionSetting, SessionType sessionType, int n, String[] stringArray, Properties properties) throws PersistentException {
        this(jDBCConnectionSetting, sessionType, n, stringArray, properties, null);
    }

    protected PersistentManager(JDBCConnectionSetting jDBCConnectionSetting, SessionType sessionType, int n, String[] stringArray, Properties properties, String string) throws PersistentException {
        File file;
        this._sessionType = sessionType;
        this._cfg = this.createConfiguration();
        if (string == null) {
            string = this.getProjectName() + ".cfg.xml";
        }
        if ((file = new File("ormmapping/" + string)).exists()) {
            this._cfg.configure(file);
        } else {
            this._cfg.configure("/ormmapping/" + string);
        }
        if (jDBCConnectionSetting != null) {
            this._cfg.setProperty("hibernate.dialect", jDBCConnectionSetting.getDialect());
            this._cfg.setProperty("hibernate.connection.driver_class", jDBCConnectionSetting.getDriverClass());
            this._cfg.setProperty("hibernate.connection.url", jDBCConnectionSetting.getConnectionURL());
            this._cfg.setProperty("hibernate.connection.username", jDBCConnectionSetting.getUserName());
            this._cfg.setProperty("hibernate.connection.password", jDBCConnectionSetting.getPassword());
        }
        if (properties != null) {
            this._cfg.addProperties(properties);
        }
        this._interceptor = new ORMInterceptor(this.getORMClassHierarchyMap(stringArray), stringArray);
        this._cfg.setInterceptor(this._interceptor);
        this._cfg.buildMappings();
        this.resolveNativeIDGenerators();
        if (this._sessionType == SessionType.APP_BASE) {
            this._sessionController = new AppBaseSessionController(this._cfg, n);
        } else if (this._sessionType == SessionType.ADVANCED_APP_BASE) {
            this._sessionController = new AdvancedAppBaseSessionController(this._cfg);
        } else if (this._sessionType == SessionType.THREAD_BASE) {
            this._sessionController = new ThreadBaseSessionController(this._cfg);
        } else if (this._sessionType == SessionType.USER_DEFINIED) {
            this._sessionController = new UserDefinedSessionController(this._cfg);
        }
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    public SessionType getSessionType() {
        return this._sessionType;
    }

    public void setFlushMode(FlushMode flushMode) {
        this._flushMode = flushMode;
    }

    private void resolveNativeIDGenerators() {
        SimpleValue simpleValue;
        Filterable filterable;
        Dialect dialect = Dialect.getDialect(this._cfg.getProperties());
        Iterator iterator = this._cfg.getClassMappings();
        while (iterator.hasNext()) {
            filterable = iterator.next();
            if (((PersistentClass)filterable).isInherited() || !(((PersistentClass)filterable).getIdentifier() instanceof SimpleValue)) continue;
            simpleValue = (SimpleValue)((PersistentClass)filterable).getIdentifier();
            this.resolveIdentifier(simpleValue, dialect);
        }
        iterator = this._cfg.getCollectionMappings();
        while (iterator.hasNext()) {
            filterable = (Collection)iterator.next();
            if (!((Collection)filterable).isIdentified() || !(((IdentifierCollection)filterable).getIdentifier() instanceof SimpleValue)) continue;
            simpleValue = (SimpleValue)((IdentifierCollection)filterable).getIdentifier();
            this.resolveIdentifier(simpleValue, dialect);
        }
    }

    private void resolveIdentifier(SimpleValue simpleValue, Dialect dialect) {
        if (simpleValue.getIdentifierGeneratorStrategy().equals("native")) {
            String string = DDLGeneratorUtil.getIDGenerator("native", dialect, this.isIntLongShort(simpleValue.getTypeName()));
            simpleValue.setIdentifierGeneratorStrategy(string);
            if (string.equals("assigned")) {
                simpleValue.setNullValue("undefined");
            } else {
                simpleValue.setNullValue(null);
                String string2 = DDLGeneratorUtil.getIDGeneratorKey(simpleValue.getTable().getSchema(), simpleValue.getTable().getName(), string, null);
                if (string.equals("sequence")) {
                    simpleValue.getIdentifierGeneratorProperties().put("sequence", string2);
                } else if (string.equals("hilo")) {
                    simpleValue.getIdentifierGeneratorProperties().put("table", string2);
                    simpleValue.getIdentifierGeneratorProperties().put("column", DDLGeneratorUtil.getDefaultIDTableColumnName());
                }
            }
        }
    }

    private boolean isIntLongShort(String string) {
        return string.equals("integer") || string.equals("long") || string.equals("short") || string.equals("int") || string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.lang.Short");
    }

    public Configuration getConfiguration() {
        return this._cfg;
    }

    public PersistentSession getSession() throws PersistentException {
        PersistentSession persistentSession = this._sessionController.getSession();
        if (persistentSession != null && this._flushMode != null) {
            persistentSession.setFlushMode(this._flushMode);
        }
        return persistentSession;
    }

    public PersistentSession getSession(boolean bl) throws PersistentException {
        PersistentSession persistentSession = this._sessionController.getSession(bl);
        if (persistentSession != null && this._flushMode != null) {
            persistentSession.setFlushMode(this._flushMode);
        }
        return persistentSession;
    }

    public void disposePersistentManager() throws PersistentException {
        this._sessionController.disposeSession();
    }

    protected static void saveJDBCConnectionSetting(String string, JDBCConnectionSetting jDBCConnectionSetting) {
        Object object;
        if (jDBCConnectionSetting == null) {
            return;
        }
        File file = new File("ormmapping/" + string + ".cfg.xml");
        InputStream inputStream = null;
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error("Save JDBC Connection Setting failed", fileNotFoundException);
                return;
            }
        } else {
            object = "/ormmapping/" + string + ".cfg.xml";
            inputStream = PersistentManager.class.getResourceAsStream((String)object);
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)object);
            }
            if (inputStream == null) {
                log.error("Save JDBC Connection Setting failed");
            }
        }
        object = new SAXReader();
        ((SAXReader)object).setMergeAdjacentText(true);
        ((SAXReader)object).setValidation(true);
        ((SAXReader)object).setEntityResolver(new DTDEntityResolver());
        try {
            Object object2;
            Object object3;
            Document document = ((SAXReader)object).read(inputStream);
            Element element = document.getRootElement().element("session-factory");
            Object object4 = element.elementIterator();
            while (object4.hasNext()) {
                object3 = (Element)object4.next();
                if (!object3.getName().equals("property")) continue;
                object2 = object3.attribute("name").getValue();
                if (((String)object2).equals("dialect")) {
                    object3.node(0).setText(jDBCConnectionSetting.getDialect());
                    continue;
                }
                if (((String)object2).equals("connection.driver_class")) {
                    object3.node(0).setText(jDBCConnectionSetting.getDriverClass());
                    continue;
                }
                if (((String)object2).equals("connection.url")) {
                    object3.node(0).setText(jDBCConnectionSetting.getConnectionURL());
                    continue;
                }
                if (((String)object2).equals("connection.username")) {
                    object3.node(0).setText(jDBCConnectionSetting.getUserName());
                    continue;
                }
                if (!((String)object2).equals("connection.password")) continue;
                if (object3.nodeCount() > 0) {
                    object3.node(0).setText(jDBCConnectionSetting.getPassword());
                    continue;
                }
                object3.addText(jDBCConnectionSetting.getPassword());
            }
            object4 = OutputFormat.createPrettyPrint();
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            object3 = new FileWriter(file);
            object2 = new XMLWriter((Writer)object3, (OutputFormat)object4);
            ((XMLWriter)object2).write(document);
            ((OutputStreamWriter)object3).close();
        }
        catch (Exception exception) {
            log.error("Save JDBC Connection Setting failed", exception);
        }
    }

    public void saveObject(Object object) throws PersistentException {
        PersistentSession persistentSession = this.getSession();
        if (!persistentSession.isTransaction() || this._sessionType == SessionType.USER_DEFINIED) {
            PersistentTransaction persistentTransaction = persistentSession.beginTransaction();
            persistentSession.saveOrUpdate(object);
            persistentTransaction.commit();
        } else {
            persistentSession.saveOrUpdate(object);
        }
        if (this._sessionType == SessionType.USER_DEFINIED) {
            persistentSession.close();
        }
    }

    public void deleteObject(Object object) throws PersistentException {
        PersistentSession persistentSession = this.getSession();
        if (!persistentSession.isTransaction() || this._sessionType == SessionType.USER_DEFINIED) {
            PersistentTransaction persistentTransaction = persistentSession.beginTransaction();
            persistentSession.delete(object);
            persistentTransaction.commit();
        } else {
            this.getSession().delete(object);
        }
        if (this._sessionType == SessionType.USER_DEFINIED) {
            persistentSession.close();
        }
    }

    public void lockObject(Object object) throws PersistentException {
        if (this._sessionType != SessionType.USER_DEFINIED) {
            PersistentSession persistentSession = this.getSession();
            persistentSession.lock(object, LockMode.NONE);
        }
    }

    public Map getORMClassHierarchyMap(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<String> list = Arrays.asList(stringArray);
        Iterator<PersistentClass> iterator = this._cfg.getClassMappings();
        while (iterator.hasNext()) {
            PersistentClass persistentClass = iterator.next();
            PersistentClass persistentClass2 = list.contains(persistentClass.getClassName()) ? persistentClass : null;
            for (PersistentClass persistentClass3 = persistentClass.getSuperclass(); persistentClass3 != null; persistentClass3 = persistentClass3.getSuperclass()) {
                if (!list.contains(persistentClass3.getClassName())) continue;
                persistentClass2 = persistentClass3;
            }
            if (persistentClass2 == null) continue;
            hashMap.put(persistentClass.getClassName(), persistentClass2.getClassName());
        }
        return hashMap;
    }

    public boolean isObjectPersistable(Object object) {
        if (object == null) {
            return false;
        }
        return this._cfg.getClassMapping(object.getClass().getName()) != null;
    }

    public void setInterceptor(Interceptor interceptor) {
        this._interceptor.setUserInterceptor(interceptor);
    }

    public Interceptor getInterceptor() {
        return this._interceptor.getUserInterceptor();
    }

    public static final class SessionType {
        public static final SessionType APP_BASE = new SessionType();
        public static final SessionType ADVANCED_APP_BASE = new SessionType();
        public static final SessionType THREAD_BASE = new SessionType();
        public static final SessionType USER_DEFINIED = new SessionType();

        private SessionType() {
        }
    }
}

