/*
 * Decompiled with CFR 0.152.
 */
package org.orm;

import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.orm.PersistentException;
import org.orm.PersistentSession;

public class PersistentTransaction {
    private final Transaction _transaction;
    private final PersistentSession _persistentSession;

    public PersistentTransaction(Transaction transaction, PersistentSession persistentSession) {
        this._transaction = transaction;
        this._persistentSession = persistentSession;
    }

    public void commit() throws PersistentException {
        this._persistentSession.setTransaction(false);
        try {
            this._transaction.commit();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public boolean equals(Object object) {
        return this._transaction.equals(object);
    }

    public int hashCode() {
        return this._transaction.hashCode();
    }

    public void rollback() throws PersistentException {
        this._persistentSession.setTransaction(false);
        try {
            this._transaction.rollback();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public String toString() {
        return this._transaction.toString();
    }

    public boolean wasCommitted() throws PersistentException {
        try {
            return this._transaction.wasCommitted();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }

    public boolean wasRolledBack() throws PersistentException {
        try {
            return this._transaction.wasRolledBack();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException(hibernateException);
        }
    }
}

