/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ermodel;

import java.util.Iterator;
import java.util.Vector;
import org.orm.ermodel.ERColumn;
import org.orm.ermodel.ERElement;
import org.orm.ermodel.EREntity;
import org.orm.ertodb.DialectDBTypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERModel {
    public static final int QUOTE_SQL_AUTO = 1;
    public static final int QUOTE_SQL_YES = 2;
    public static final int QUOTE_SQL_NO = 3;
    private Vector<ERElement> _elements = new Vector();
    private int _quoteSQLIdentifier;
    private String _tableCharset;
    private String _mySQLVersion;
    private String _msSQLVersion;
    private String _derbyVersion;

    public void setQuoteSQLIdentifier(int n) {
        this._quoteSQLIdentifier = n;
    }

    public int getQuoteSQLIdentifier() {
        return this._quoteSQLIdentifier;
    }

    public String getTableCharset() {
        return this._tableCharset;
    }

    public void setTableCharset(String string) {
        this._tableCharset = string;
    }

    public Iterator<ERElement> elementIterator() {
        return this._elements.iterator();
    }

    public void addElement(ERElement eRElement) {
        this._elements.add(eRElement);
    }

    public EREntity getEntityByName(String string) {
        EREntity eREntity = null;
        Iterator<ERElement> iterator = this.elementIterator();
        while (iterator.hasNext()) {
            ERElement eRElement = iterator.next();
            if (!(eRElement instanceof EREntity) || !eRElement.getName().equals(string)) continue;
            eREntity = (EREntity)eRElement;
            break;
        }
        return eREntity;
    }

    public ERColumn getColumnByFullName(String string) {
        EREntity eREntity;
        ERColumn eRColumn = null;
        int n = string.indexOf(46);
        if (n > 0 && (eREntity = this.getEntityByName(string.substring(0, n))) != null) {
            eRColumn = eREntity.getColumnByName(string.substring(n + 1));
        }
        return eRColumn;
    }

    public void setMySQLVersion(String string) {
        this._mySQLVersion = string;
        if ("505".equals(string)) {
            DialectDBTypeMapper.instance().mapVersion(2, 0x100000);
        } else {
            DialectDBTypeMapper.instance().mapVersion(2, 2);
        }
    }

    public void setMsSQLVersion(String string) {
        this._msSQLVersion = string;
        if ("2008".equals(string)) {
            DialectDBTypeMapper.instance().mapVersion(8, 0x200000);
        } else {
            DialectDBTypeMapper.instance().mapVersion(8, 8);
        }
    }

    public String getMySQLVersion() {
        return this._mySQLVersion;
    }

    public String getMsSQLVersion() {
        return this._msSQLVersion;
    }

    public void setDerbyVersion(String string) {
        this._derbyVersion = string;
        if ("107".equals(string)) {
            DialectDBTypeMapper.instance().mapVersion(512, 0x400000);
        } else {
            DialectDBTypeMapper.instance().mapVersion(512, 512);
        }
    }

    public String getDerbyVersion() {
        return this._derbyVersion;
    }
}

