/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ermodel.handler;

import java.util.Iterator;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Element;
import org.orm.ermodel.ERColumn;
import org.orm.ermodel.EREntity;
import org.orm.ermodel.handler.ERElementHandlerUtil;
import org.orm.ormtypemapper.DBTypeUtil;

public class ERColumnHandler {
    public Element createElement(Branch branch, ERColumn eRColumn) {
        String string;
        Element element = branch.addElement("Column").addAttribute("name", eRColumn.getName());
        ERElementHandlerUtil.addTextElement(element, "PrimaryKey", eRColumn.isPrimaryKey());
        ERElementHandlerUtil.addTextElement(element, "ForeignKey", eRColumn.isForeignKey());
        if (eRColumn.isForeignKey()) {
            ERElementHandlerUtil.addTextElement(element, "ReferencedColumn", eRColumn.getReferencedColumn());
        }
        ERElementHandlerUtil.addTextElement(element, "Type", eRColumn.getType());
        ERElementHandlerUtil.addTextElement(element, "Length", eRColumn.getLength());
        if (DBTypeUtil.getDBTypeByID(eRColumn.getType()).isDecimal()) {
            ERElementHandlerUtil.addTextElement(element, "Scale", eRColumn.getScale());
        }
        ERElementHandlerUtil.addTextElement(element, "Nullable", eRColumn.isNullable());
        ERElementHandlerUtil.addTextElement(element, "IDGenerator", eRColumn.getIdGenerator());
        ERElementHandlerUtil.addTextElement(element, "IDGeneratorKey", eRColumn.getIdGeneratorKey());
        ERElementHandlerUtil.addTextElement(element, "Unique", eRColumn.isUnique());
        ERElementHandlerUtil.addTextElement(element, "Index", eRColumn.isIndex());
        ERElementHandlerUtil.addTextElement(element, "CheckConstraint", eRColumn.getCheckConstraint());
        String string2 = eRColumn.getDefaultValue();
        if (string2 != null && string2.length() > 0) {
            ERElementHandlerUtil.addTextElement(element, "DefaultValue", string2);
        }
        if ((string = eRColumn.getComment()) != null && string.length() > 0) {
            ERElementHandlerUtil.addTextElement(element, "Comment", string);
        }
        Element element2 = element.addElement("UserTypes");
        Map<Integer, String> map = eRColumn.getUserTypes();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            int n = entry.getKey();
            element2.addElement("UserType").addAttribute("DBType", String.valueOf(n)).addText(entry.getValue());
        }
        String string3 = eRColumn.getExtraDDLClause();
        if (string3 != null && string3.length() > 0) {
            ERElementHandlerUtil.addTextElement(element, "ExtraDDLClause", string3);
        }
        if (eRColumn.getIdentitySeed() != -1) {
            ERElementHandlerUtil.addTextElement(element, "IdentitySeed", eRColumn.getIdentitySeed());
        }
        if (eRColumn.getIdentityIncrement() != -1) {
            ERElementHandlerUtil.addTextElement(element, "IdentityIncrement", eRColumn.getIdentityIncrement());
        }
        return element;
    }

    public ERColumn readERElement(EREntity eREntity, Element element) {
        ERColumn eRColumn = new ERColumn(eREntity);
        eRColumn.setName(element.attribute("name").getValue());
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2.getName().equals("PrimaryKey")) {
                eRColumn.setPrimaryKey(ERElementHandlerUtil.getTextAsBoolean(element2));
                continue;
            }
            if (element2.getName().equals("ForeignKey")) {
                eRColumn.setForeignKey(ERElementHandlerUtil.getTextAsBoolean(element2));
                continue;
            }
            if (element2.getName().equals("ReferencedColumn")) {
                eRColumn.setReferencedColumn(ERElementHandlerUtil.getText(element2));
                continue;
            }
            if (element2.getName().equals("Type")) {
                eRColumn.setType(ERElementHandlerUtil.getTextAsInt(element2));
                continue;
            }
            if (element2.getName().equals("Length")) {
                eRColumn.setLength(ERElementHandlerUtil.getTextAsInt(element2));
                continue;
            }
            if (element2.getName().equals("Nullable")) {
                eRColumn.setNullable(ERElementHandlerUtil.getTextAsBoolean(element2));
                continue;
            }
            if (element2.getName().equals("IDGenerator")) {
                eRColumn.setIdGenerator(ERElementHandlerUtil.getText(element2));
                continue;
            }
            if (element2.getName().equals("IDGeneratorKey")) {
                eRColumn.setIdGeneratorKey(ERElementHandlerUtil.getText(element2));
                continue;
            }
            if (element2.getName().equals("Unique")) {
                eRColumn.setUnique(ERElementHandlerUtil.getTextAsBoolean(element2));
                continue;
            }
            if (element2.getName().equals("Index")) {
                eRColumn.setIndex(ERElementHandlerUtil.getTextAsBoolean(element2));
                continue;
            }
            if (element2.getName().equals("CheckConstraint")) {
                eRColumn.setCheckConstraint(ERElementHandlerUtil.getText(element2));
                continue;
            }
            if (element2.getName().equals("DefaultValue")) {
                eRColumn.setDefaultValue(ERElementHandlerUtil.getText(element2));
                continue;
            }
            if (element2.getName().equals("Comment")) {
                eRColumn.setComment(ERElementHandlerUtil.getText(element2));
                continue;
            }
            if (element2.getName().equals("Scale")) {
                eRColumn.setScale(ERElementHandlerUtil.getTextAsInt(element2));
                continue;
            }
            if (element2.getName().equals("UserTypes")) {
                Iterator iterator2 = element2.elementIterator("UserType");
                while (iterator2.hasNext()) {
                    Element element3 = (Element)iterator2.next();
                    String string = element3.attributeValue("DBType");
                    String string2 = ERElementHandlerUtil.getText(element3);
                    eRColumn.addUserType(Integer.parseInt(string), string2);
                }
                continue;
            }
            if (element2.getName().equals("ExtraDDLClause")) {
                eRColumn.setExtraDDLClause(ERElementHandlerUtil.getText(element2));
                continue;
            }
            if (element2.getName().equals("IdentitySeed")) {
                eRColumn.setIdentitySeed(ERElementHandlerUtil.getTextAsInt(element2));
                continue;
            }
            if (!element2.getName().equals("IdentityIncrement")) continue;
            eRColumn.setIdentityIncrement(ERElementHandlerUtil.getTextAsInt(element2));
        }
        return eRColumn;
    }
}

