/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ermodel.handler;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.orm.cfg.JDBCSettings;
import org.orm.ermodel.ERElement;
import org.orm.ermodel.EREntity;
import org.orm.ermodel.ERForeignKey;
import org.orm.ermodel.ERModel;
import org.orm.ermodel.ERProcedure;
import org.orm.ermodel.ERSequence;
import org.orm.ermodel.ERTrigger;
import org.orm.ermodel.ERView;
import org.orm.ermodel.handler.EREntityHandler;
import org.orm.ermodel.handler.ERForeignKeyHandler;
import org.orm.ermodel.handler.ERProcedureHandler;
import org.orm.ermodel.handler.ERSequenceHandler;
import org.orm.ermodel.handler.ERTriggerHandler;
import org.orm.ermodel.handler.ERViewHandler;

public class ERModelHandler {
    EREntityHandler _entityHandler = new EREntityHandler();
    private ERForeignKeyHandler _foreignKeyHandler = new ERForeignKeyHandler();
    private ERViewHandler _viewHandler = new ERViewHandler();
    private ERProcedureHandler _procedureHandler = new ERProcedureHandler();
    private ERTriggerHandler _triggerHandler = new ERTriggerHandler();
    private ERSequenceHandler _sequenceHandler = new ERSequenceHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, ERModel eRModel) {
        Document document = this.createDocument(eRModel);
        XMLWriter xMLWriter = null;
        try {
            String string2 = document.getXMLEncoding();
            if (string2 == null) {
                string2 = "UTF-8";
            }
            xMLWriter = new XMLWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2), OutputFormat.createPrettyPrint());
            xMLWriter.write(document);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                xMLWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERModel load(String string) {
        InputStream inputStream = JDBCSettings.class.getResourceAsStream(string);
        if (inputStream == null) {
            if (string.startsWith("/")) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string.substring(1));
            }
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            }
        }
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            return null;
        }
        SAXReader sAXReader = new SAXReader();
        InputStreamReader inputStreamReader = null;
        try {
            ERModel eRModel;
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            Document document = sAXReader.read(inputStreamReader);
            ERModel eRModel2 = eRModel = this.parseDocument(document);
            return eRModel2;
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private Document createDocument(ERModel eRModel) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("Model");
        element.addAttribute("quotesql", String.valueOf(eRModel.getQuoteSQLIdentifier()));
        element.addAttribute("tablecharset", String.valueOf(eRModel.getTableCharset()));
        if (eRModel.getMySQLVersion() != null) {
            element.addAttribute("mysql_version", eRModel.getMySQLVersion());
        }
        if (eRModel.getMsSQLVersion() != null) {
            element.addAttribute("mssql_version", eRModel.getMsSQLVersion());
        }
        if (eRModel.getDerbyVersion() != null) {
            element.addAttribute("derby_version", eRModel.getDerbyVersion());
        }
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            ERElement eRElement = iterator.next();
            if (eRElement instanceof EREntity) {
                this._entityHandler.createElement(element, (EREntity)eRElement);
                continue;
            }
            if (eRElement instanceof ERForeignKey) {
                this._foreignKeyHandler.createElement(element, (ERForeignKey)eRElement);
                continue;
            }
            if (eRElement instanceof ERView) {
                this._viewHandler.createElement(element, (ERView)eRElement);
                continue;
            }
            if (eRElement instanceof ERProcedure) {
                this._procedureHandler.createElement(element, (ERProcedure)eRElement);
                continue;
            }
            if (eRElement instanceof ERTrigger) {
                this._triggerHandler.createElement(element, (ERTrigger)eRElement);
                continue;
            }
            if (!(eRElement instanceof ERSequence)) continue;
            this._sequenceHandler.createElement(element, (ERSequence)eRElement);
        }
        return document;
    }

    private ERModel parseDocument(Document document) {
        ERModel eRModel = new ERModel();
        Element element = document.getRootElement();
        if (element.attributeCount() > 0) {
            eRModel.setQuoteSQLIdentifier(Integer.parseInt(element.attributeValue("quotesql")));
            if (element.attribute("tablecharset") != null) {
                eRModel.setTableCharset(element.attributeValue("tablecharset"));
            }
            if (element.attribute("mysql_version") != null) {
                eRModel.setMySQLVersion(element.attributeValue("mysql_version"));
            }
            if (element.attribute("mssql_version") != null) {
                eRModel.setMsSQLVersion(element.attributeValue("mssql_version"));
            }
            if (element.attribute("derby_version") != null) {
                eRModel.setDerbyVersion(element.attributeValue("derby_version"));
            }
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2.getName().equals("Entity")) {
                eRModel.addElement(this._entityHandler.readERElement(eRModel, element2));
                continue;
            }
            if (element2.getName().equals("ForeignKey")) {
                eRModel.addElement(this._foreignKeyHandler.readERElement(eRModel, element2));
                continue;
            }
            if (element2.getName().equals("View")) {
                eRModel.addElement(this._viewHandler.readERElement(eRModel, element2));
                continue;
            }
            if (element2.getName().equals("Procedure")) {
                eRModel.addElement(this._procedureHandler.readERElement(eRModel, element2));
                continue;
            }
            if (element2.getName().equals("Trigger")) {
                eRModel.addElement(this._triggerHandler.readERElement(eRModel, element2));
                continue;
            }
            if (!element2.getName().equals("Sequence")) continue;
            eRModel.addElement(this._sequenceHandler.readERElement(eRModel, element2));
        }
        return eRModel;
    }
}

