/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.util.StringHelper;
import org.orm.ProgressMonitor;
import org.orm.ermodel.ERColumn;
import org.orm.ermodel.ERElement;
import org.orm.ermodel.EREntity;
import org.orm.ermodel.ERForeignKey;
import org.orm.ermodel.ERIndex;
import org.orm.ermodel.ERIndexColumn;
import org.orm.ermodel.ERModel;
import org.orm.ermodel.ERProcedure;
import org.orm.ermodel.ERSequence;
import org.orm.ermodel.ERTrigger;
import org.orm.ermodel.ERView;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.DDLOptions;
import org.orm.ertodb.DDLStatementCollection;
import org.orm.ertodb.DialectDBTypeMapper;
import org.orm.ertodb.ForeignKeyDDLGenerator;
import org.orm.ertodb.IndexInfo;
import org.orm.ertodb.ProcedureDDLGenerator;
import org.orm.ertodb.SQLReservedWordChecker;
import org.orm.ertodb.SequenceDDLGenerator;
import org.orm.ertodb.TableDDLGenerator;
import org.orm.ertodb.TriggerDDLGenerator;
import org.orm.ertodb.UniqueKeyInfo;
import org.orm.ertodb.ViewDDLGenerator;
import org.orm.ertodb.metadata.ColumnMetadata;
import org.orm.ertodb.metadata.DatabaseMetadata;
import org.orm.ertodb.metadata.ForeignKeyMetadata;
import org.orm.ertodb.metadata.IndexMetadata;
import org.orm.ertodb.metadata.TableMetadata;
import org.orm.ertodb.metadata.UniqueConstraintMetadata;
import org.orm.ormtypemapper.DBTypeUtil;

public class DDLGenerator {
    private TableDDLGenerator _tableDDLGenerator;
    private ForeignKeyDDLGenerator _foreignKeyDDLGenerator;
    private ViewDDLGenerator _viewDDLGenerator;
    private ProcedureDDLGenerator _procedureDDLGenerator;
    private TriggerDDLGenerator _triggerDDLGenerator;
    private SequenceDDLGenerator _sequenceDDLGenerator;
    private final DDLOptions _ddlOption;
    private boolean _upperCaseSQL;
    private boolean _formattedSQL;

    public DDLGenerator(DDLOptions dDLOptions) {
        this._ddlOption = dDLOptions;
        this._tableDDLGenerator = new TableDDLGenerator(this);
        this._foreignKeyDDLGenerator = new ForeignKeyDDLGenerator(this);
        this._procedureDDLGenerator = new ProcedureDDLGenerator(this);
        this._viewDDLGenerator = new ViewDDLGenerator(this);
        this._triggerDDLGenerator = new TriggerDDLGenerator(this);
        this._sequenceDDLGenerator = new SequenceDDLGenerator(this);
    }

    public DDLGenerator() {
        this(new DDLOptions(true, false));
    }

    DDLOptions getDdlOption() {
        return this._ddlOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSchema(String[] stringArray, String string) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().toLowerCase().equals("go")) {
                    printWriter.println(stringArray[i]);
                    continue;
                }
                printWriter.println(stringArray[i] + ";");
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSchema(String[] stringArray, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().toLowerCase().equals("go")) continue;
                statement.executeUpdate(stringArray[i]);
            }
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createProcedures(ERModel eRModel, Dialect dialect) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<String[]> vector = new Vector<String[]>(5);
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (!(stringArray instanceof ERProcedure)) continue;
            vector.add(stringArray);
        }
        int n = eRModel.getQuoteSQLIdentifier();
        this._procedureDDLGenerator.setDialect(dialect);
        stringArray = this._procedureDDLGenerator.generateCreateDDL(vector.toArray(new ERProcedure[vector.size()]), n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createTriggers(ERModel eRModel, Dialect dialect) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<String[]> vector = new Vector<String[]>(5);
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (!(stringArray instanceof ERTrigger)) continue;
            vector.add(stringArray);
        }
        int n = eRModel.getQuoteSQLIdentifier();
        this._triggerDDLGenerator.setDialect(dialect);
        stringArray = this._triggerDDLGenerator.generateCreateDDL(vector.toArray(new ERTrigger[vector.size()]), n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createSequences(ERModel eRModel, Dialect dialect) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<String[]> vector = new Vector<String[]>(5);
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            if (!(stringArray instanceof ERSequence)) continue;
            vector.add(stringArray);
        }
        int n = eRModel.getQuoteSQLIdentifier();
        this._sequenceDDLGenerator.setDialect(dialect);
        stringArray = this._sequenceDDLGenerator.generateCreateDDL(vector.toArray(new ERSequence[vector.size()]), n);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public DDLStatementCollection createSchema(ERModel eRModel, Dialect dialect) throws HibernateException, SQLException {
        return this.createSchema(eRModel, dialect, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDLStatementCollection createSchema(ERModel eRModel, Dialect dialect, ProgressMonitor progressMonitor) throws HibernateException, SQLException {
        int n;
        String[] stringArray;
        Object object;
        Object object2;
        String[] stringArray2;
        int n2 = 0;
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            ERElement eRElement = iterator.next();
            if (!(eRElement instanceof EREntity) && !(eRElement instanceof ERView) && !(eRElement instanceof ERForeignKey)) continue;
            ++n2;
        }
        progressMonitor.maxProgressCalculated(n2);
        int n3 = 0;
        boolean bl = dialect instanceof PostgreSQLDialect;
        DDLStatementCollection dDLStatementCollection = new DDLStatementCollection();
        if (bl) {
            stringArray2 = this.generateTablesForIDGenerator(eRModel, dialect, null, eRModel.getQuoteSQLIdentifier());
            for (int i = 0; i < stringArray2.length; ++i) {
                dDLStatementCollection.addUnknownStatement(stringArray2[i]);
            }
        }
        stringArray2 = new HashMap();
        if (dialect.createForeignKeyInCreateTable()) {
            Iterator<ERElement> iterator2 = eRModel.elementIterator();
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                if (!(object2 instanceof ERForeignKey)) continue;
                object = ((ERForeignKey)object2).getReferenceTable();
                stringArray = (String[])stringArray2.get(object);
                if (stringArray == null) {
                    stringArray = new ArrayList();
                    stringArray2.put(object, stringArray);
                }
                stringArray.add(object2);
            }
        }
        Object object3 = eRModel.elementIterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (!(object2 instanceof EREntity)) continue;
            object = (ArrayList)stringArray2.get(object2.getName());
            this._tableDDLGenerator.generateCreateDDL(dDLStatementCollection, (EREntity)object2, dialect, object == null ? null : ((ArrayList)object).toArray(new ERForeignKey[((ArrayList)object).size()]));
            stringArray = this._tableDDLGenerator.generateComment((EREntity)object2, dialect, null);
            for (n = 0; n < stringArray.length; ++n) {
                dDLStatementCollection.addTableStatement(stringArray[n]);
            }
            progressMonitor.progressUpdate(++n3);
        }
        object3 = new ArrayList();
        object2 = eRModel.elementIterator();
        while (object2.hasNext()) {
            object = (ERElement)object2.next();
            if (!(object instanceof ERView) || ((ERView)object).getCreateStmt() == null) continue;
            object3.add(object);
        }
        object2 = object3.toArray(new ERView[object3.size()]);
        for (int i = 0; i < ((ERView[])object2).length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (i == j || (n = object2[j].getCreateStmt().toLowerCase().indexOf(object2[i].getName().toLowerCase())) <= 0 || !Character.isWhitespace(object2[j].getCreateStmt().charAt(n - 1)) || !Character.isWhitespace(object2[j].getCreateStmt().charAt(n + object2[i].getName().length()))) continue;
                object3.remove(object2[i]);
                object3.add(object3.indexOf(object2[j]), object2[i]);
            }
            progressMonitor.progressUpdate(++n3);
        }
        Iterator iterator3 = object3.iterator();
        while (iterator3.hasNext()) {
            ERView eRView = (ERView)iterator3.next();
            String string = eRView.getCreateStmt();
            dDLStatementCollection.addViewStatement(string);
        }
        int n4 = eRModel.getQuoteSQLIdentifier();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray3 = eRModel.elementIterator();
        block11: while (stringArray3.hasNext()) {
            Object object4;
            String[] stringArray4;
            Object object5;
            Object object6 = stringArray3.next();
            if (object6 instanceof EREntity) {
                Object object7;
                Object object8;
                Object object9;
                Iterator iterator4;
                object5 = (EREntity)object6;
                if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                    stringArray4 = ((EREntity)object5).uniqueKeysIterator();
                    while (stringArray4.hasNext()) {
                        iterator4 = (String)stringArray4.next();
                        object9 = new StringBuffer(this.convertKeywordCase("create unique index "));
                        ((StringBuffer)object9).append((String)(dialect.qualifyIndexName() && !(dialect instanceof PostgreSQLDialect) ? iterator4 : StringHelper.unqualify((String)((Object)iterator4)))).append(this.convertKeywordCase(" on ")).append(DDLGeneratorUtil.getQualifiedName(((EREntity)object5).getSchema(), ((ERElement)object5).getName(), dialect, n4)).append(" (");
                        object4 = ((EREntity)object5).uniqueKeyColumnsIterator((String)((Object)iterator4));
                        while (object4.hasNext()) {
                            ((StringBuffer)object9).append(DDLGeneratorUtil.quoteName((String)object4.next(), dialect, n4));
                            if (!object4.hasNext()) continue;
                            ((StringBuffer)object9).append(", ");
                        }
                        ((StringBuffer)object9).append(")");
                        dDLStatementCollection.addIndexStatement(((StringBuffer)object9).toString());
                    }
                }
                stringArray4 = new HashSet();
                iterator4 = ((EREntity)object5).indicesIterator();
                while (iterator4.hasNext()) {
                    object9 = (ERIndex)iterator4.next();
                    object4 = ((ERIndex)object9).getName();
                    if (stringArray4.contains(object4)) continue;
                    stringArray4.add(object4);
                    object8 = new IndexInfo((String)object4, ((ERIndex)object9).isUnique(), ((ERElement)object5).getName(), ((EREntity)object5).getSchema(), ((ERIndex)object9).getTablespace(), ((ERIndex)object9).getFunction(), ((ERIndex)object9).getClustered());
                    object7 = ((ERIndex)object9).columnIterator();
                    while (object7.hasNext()) {
                        ((IndexInfo)object8).addColumn((ERIndexColumn)object7.next());
                    }
                    arrayList.add(object8);
                }
                if (dialect.supportsIndexConstraintInCreateAlterTable()) continue;
                object9 = ((EREntity)object5).elementIterator();
                while (object9.hasNext()) {
                    object4 = object9.next();
                    if (!(object4 instanceof ERColumn) || !((ERColumn)(object8 = (ERColumn)object4)).isIndex() || stringArray4.contains(object7 = ((ERElement)object5).getName() + "_" + ((ERElement)object8).getName())) continue;
                    stringArray4.add(object7);
                    IndexInfo indexInfo = new IndexInfo((String)object7, ((ERColumn)object8).isUnique(), ((ERElement)object5).getName(), ((EREntity)object5).getSchema(), null, null, 0);
                    indexInfo.addColumn(new ERIndexColumn(((ERElement)object8).getName()));
                    arrayList.add(indexInfo);
                }
                continue;
            }
            if (!(object6 instanceof ERForeignKey) || !dialect.hasAlterTable()) continue;
            object5 = this._foreignKeyDDLGenerator.generateDDL((ERForeignKey)object6, dialect);
            if (object5 != null) {
                dDLStatementCollection.addFKStatement((String)object5);
            }
            progressMonitor.progressUpdate(++n3);
            if (!(dialect instanceof MySQLDialect)) continue;
            stringArray4 = ((ERForeignKey)object6).getColumns();
            for (Object object9 : arrayList) {
                if (((IndexInfo)object9).isUnique() || stringArray4.length != ((ERIndexColumn[])(object4 = ((IndexInfo)object9).getColumns())).length) continue;
                boolean bl2 = true;
                for (int i = 0; i < stringArray4.length; ++i) {
                    if (stringArray4[i].equals(((ERIndexColumn)object4[i]).getColumnName()) && ((ERIndexColumn)object4[i]).getOrder() != 2) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                arrayList.remove(object9);
                continue block11;
            }
        }
        for (Object object6 : arrayList) {
            dDLStatementCollection.addIndexStatement(this.generateCreateIndex(dialect, n4, (IndexInfo)object6));
        }
        if (!bl) {
            stringArray3 = this.generateTablesForIDGenerator(eRModel, dialect, null, n4);
            for (int i = 0; i < stringArray3.length; ++i) {
                dDLStatementCollection.addUnknownStatement(stringArray3[i]);
            }
        }
        stringArray3 = dDLStatementCollection;
        return stringArray3;
    }

    private String generateCreateIndex(Dialect dialect, int n, IndexInfo indexInfo) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("create "));
        if (indexInfo.isUnique()) {
            stringBuffer.append(this.convertKeywordCase("unique "));
        }
        int n2 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
        int n3 = indexInfo.getClustered();
        if (n3 != 0) {
            if (n2 == 8 || n2 == 64 || n2 == 128) {
                if (n3 == 1) {
                    stringBuffer.append(this.convertKeywordCase("clustered "));
                } else if (n3 == 2) {
                    stringBuffer.append(this.convertKeywordCase("nonclustered "));
                }
            } else if (n2 == 2048 && n3 == 1) {
                stringBuffer.append(this.convertKeywordCase("cluster "));
            }
        }
        stringBuffer.append(this.convertKeywordCase("index "));
        String string = indexInfo.getName();
        String string2 = dialect.qualifyIndexName() && !(dialect instanceof PostgreSQLDialect) ? DDLGeneratorUtil.getQualifiedName(indexInfo.getSchema(), StringHelper.unqualify(string), dialect, n) : string;
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        if (this._formattedSQL) {
            stringBuffer.append("\n  ");
        }
        stringBuffer.append(this.convertKeywordCase("on ")).append(DDLGeneratorUtil.getQualifiedName(indexInfo.getSchema(), indexInfo.getEntity(), dialect, n)).append(" (");
        String string3 = indexInfo.getFunction();
        if ((n2 == 16 || n2 == 256) && string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
        } else {
            object2 = indexInfo.columnIterator();
            while (object2.hasNext()) {
                object = object2.next();
                stringBuffer.append(DDLGeneratorUtil.quoteName(((ERIndexColumn)object).getColumnName(), dialect, n));
                if (((ERIndexColumn)object).getOrder() == 1) {
                    stringBuffer.append(" asc");
                } else if (((ERIndexColumn)object).getOrder() == 2) {
                    stringBuffer.append(" desc");
                }
                if (!object2.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(")");
        object2 = indexInfo.getTablespace();
        object = dialect.getCreateTableInTablespaceKeyword();
        if (object != null && object2 != null && ((String)object2).length() > 0) {
            stringBuffer.append(" ").append(this.convertKeywordCase((String)object)).append(" ").append((String)object2);
        }
        if (n3 != 0 && n2 == 1024 && n3 == 1) {
            stringBuffer.append(this.convertKeywordCase(" cluster"));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dropProcedures(ERModel eRModel, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERProcedure)) continue;
            vector.add(eRElement);
        }
        this._procedureDDLGenerator.setDialect(dialect);
        stringArray = this._procedureDDLGenerator.generateDropDDL(vector.toArray(new ERProcedure[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dropTriggers(ERModel eRModel, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERTrigger)) continue;
            vector.add(eRElement);
        }
        this._triggerDDLGenerator.setDialect(dialect);
        stringArray = this._triggerDDLGenerator.generateDropDDL(vector.toArray(new ERTrigger[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dropSequences(ERModel eRModel, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERSequence)) continue;
            vector.add(eRElement);
        }
        this._sequenceDDLGenerator.setDialect(dialect);
        stringArray = this._sequenceDDLGenerator.generateDropDDL(vector.toArray(new ERSequence[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public DDLStatementCollection dropSchema(ERModel eRModel, Dialect dialect) {
        return this.dropSchema(eRModel, dialect, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDLStatementCollection dropSchema(ERModel eRModel, Dialect dialect, ProgressMonitor progressMonitor) {
        int n = 0;
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            ERElement eRElement = iterator.next();
            if (!(eRElement instanceof EREntity) && !(eRElement instanceof ERView) && !(eRElement instanceof ERForeignKey)) continue;
            ++n;
        }
        progressMonitor.maxProgressCalculated(n + 10);
        int n2 = 0;
        boolean bl = dialect instanceof PostgreSQLDialect;
        DDLStatementCollection dDLStatementCollection = new DDLStatementCollection();
        try {
            int n3;
            Object object;
            if (!bl) {
                object = this.dropTablesForIDGenerator(eRModel, dialect);
                for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                    dDLStatementCollection.addTableStatement((String)object[n3]);
                }
                progressMonitor.progressUpdate(n2 += 10);
            }
            if (dialect.dropConstraints()) {
                object = eRModel.elementIterator();
                while (object.hasNext()) {
                    ERElement eRElement = (ERElement)object.next();
                    if (!(eRElement instanceof ERForeignKey)) continue;
                    String string = this._foreignKeyDDLGenerator.generateDropSQL((ERForeignKey)eRElement, dialect, eRElement.getName());
                    if (string != null) {
                        dDLStatementCollection.addFKStatement(string);
                    }
                    progressMonitor.progressUpdate(++n2);
                }
            }
            object = eRModel.elementIterator();
            while (object.hasNext()) {
                ERElement eRElement = (ERElement)object.next();
                if (!(eRElement instanceof ERView)) continue;
                dDLStatementCollection.addTableStatement(this._viewDDLGenerator.generateDropSQL((ERView)eRElement, dialect));
                progressMonitor.progressUpdate(++n2);
            }
            object = eRModel.elementIterator();
            while (object.hasNext()) {
                ERElement eRElement = (ERElement)object.next();
                if (!(eRElement instanceof EREntity)) continue;
                dDLStatementCollection.addTableStatement(this._tableDDLGenerator.generateDropSQL((EREntity)eRElement, dialect));
                progressMonitor.progressUpdate(++n2);
            }
            if (bl) {
                object = this.dropTablesForIDGenerator(eRModel, dialect);
                for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                    dDLStatementCollection.addTableStatement((String)object[n3]);
                }
                progressMonitor.progressUpdate(n2 += 10);
            }
            object = dDLStatementCollection;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DDLStatementCollection dDLStatementCollection2 = null;
            return dDLStatementCollection2;
        }
    }

    private String[] dropTablesForIDGenerator(ERModel eRModel, Dialect dialect) {
        Object object;
        ERElement eRElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            eRElement = iterator.next();
            if (!(eRElement instanceof ERSequence)) continue;
            object = (ERSequence)eRElement;
            if (((ERSequence)object).getSchema() != null && ((ERSequence)object).getSchema().length() > 0) {
                hashSet.add(((ERSequence)object).getSchema() + "." + ((ERElement)object).getName());
                continue;
            }
            hashSet.add(eRElement.getName());
        }
        iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            eRElement = iterator.next();
            if (!(eRElement instanceof EREntity)) continue;
            object = new ArrayList();
            Object object4 = ((EREntity)eRElement).elementIterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                if (!(object3 instanceof ERColumn) || !((ERColumn)(object2 = (ERColumn)object3)).isPrimaryKey() || ((ERColumn)object2).isForeignKey()) continue;
                ((ArrayList)object).add(object2);
            }
            if (((ArrayList)object).size() != 1 || !this.needTableForGenerator((String)(object3 = DDLGeneratorUtil.getIDGenerator(((ERColumn)(object4 = (ERColumn)((ArrayList)object).get(0))).getIdGenerator(), dialect, DBTypeUtil.isIntType(((ERColumn)object4).getType()))), dialect) || hashSet.contains(object2 = DDLGeneratorUtil.getIDGeneratorKey(((ERColumn)object4).getEntity().getSchema(), ((ERColumn)object4).getEntity().getName(), (String)object3, ((ERColumn)object4).getIdGeneratorKey()))) continue;
            String[] stringArray = this.dropTableForIDGenerator((String)object3, (String)object2, DDLGeneratorUtil.getDefaultIDTableColumnName(), dialect);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
            hashSet.add(object2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] updateProcedures(ERModel eRModel, Connection connection, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERProcedure)) continue;
            vector.add(eRElement);
        }
        this._procedureDDLGenerator.setDialect(dialect);
        stringArray = this._procedureDDLGenerator.generateUpdateDDL(vector.toArray(new ERProcedure[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] updateTriggers(ERModel eRModel, Connection connection, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERTrigger)) continue;
            vector.add(eRElement);
        }
        this._triggerDDLGenerator.setDialect(dialect);
        stringArray = this._triggerDDLGenerator.generateUpdateDDL(vector.toArray(new ERTrigger[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] updateSequences(ERModel eRModel, Connection connection, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>(30);
        Vector<ERElement> vector = new Vector<ERElement>(5);
        String[] stringArray = eRModel.elementIterator();
        while (stringArray.hasNext()) {
            ERElement eRElement = stringArray.next();
            if (!(eRElement instanceof ERSequence)) continue;
            vector.add(eRElement);
        }
        this._sequenceDDLGenerator.setDialect(dialect);
        stringArray = this._sequenceDDLGenerator.generateUpdateDDL(vector.toArray(new ERSequence[vector.size()]), eRModel.getQuoteSQLIdentifier());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public DDLStatementCollection updateSchema(ERModel eRModel, Connection connection, Dialect dialect, String string, boolean bl, ERModel eRModel2) throws HibernateException, SQLException {
        return this.updateSchema(eRModel, connection, dialect, string, bl, eRModel2, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public DDLStatementCollection updateSchema(ERModel eRModel, Connection connection, Dialect dialect, String string, boolean bl, ERModel eRModel2, ProgressMonitor progressMonitor) throws HibernateException, SQLException {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        Object object5;
        int n = 0;
        if (bl) {
            n += 50;
        }
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            object5 = iterator.next();
            if (!(object5 instanceof EREntity) && !(object5 instanceof ERView) && !(object5 instanceof ERForeignKey)) continue;
            ++n;
        }
        progressMonitor.maxProgressCalculated(n);
        int n2 = 0;
        object5 = new DDLStatementCollection();
        if (bl) {
            this.updateDropSchema((DDLStatementCollection)object5, eRModel2, connection, dialect, string);
            progressMonitor.progressUpdate(n2 += 50);
        }
        int n3 = eRModel.getQuoteSQLIdentifier();
        int n4 = ((DDLStatementCollection)object5).size();
        boolean bl2 = dialect instanceof PostgreSQLDialect;
        DatabaseMetadata databaseMetadata = new DatabaseMetadata(connection, dialect);
        if (bl2) {
            stringArray = this.generateTablesForIDGenerator(eRModel, dialect, databaseMetadata, n3);
            for (int i = 0; i < stringArray.length; ++i) {
                ((DDLStatementCollection)object5).addUnknownStatement(stringArray[i]);
            }
        }
        stringArray = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray2 = eRModel.elementIterator();
        while (stringArray2.hasNext()) {
            ERElement object42 = stringArray2.next();
            if (object42 instanceof EREntity) {
                Object object4;
                Object object6;
                Object object7;
                int n5;
                Object object8;
                Object object9;
                Iterator<ERElement> iterator2;
                Object object10;
                object3 = (EREntity)object42;
                object2 = ((EREntity)object3).getSchema();
                if (object2 == null && dialect instanceof Oracle9Dialect) {
                    object2 = string;
                }
                if ((object = databaseMetadata.getTableMetadata((String)object2, object42.getName(), eRModel.getQuoteSQLIdentifier() == 2)) == null) {
                    object10 = new ArrayList();
                    if (dialect.createForeignKeyInCreateTable()) {
                        iterator2 = eRModel.elementIterator();
                        while (iterator2.hasNext()) {
                            object9 = iterator2.next();
                            if (!(object9 instanceof ERForeignKey) || !((String)(object8 = ((ERForeignKey)object9).getReferenceTable())).equals(object42.getName())) continue;
                            ((ArrayList)object10).add(object9);
                        }
                    }
                    this._tableDDLGenerator.generateCreateDDL((DDLStatementCollection)object5, (EREntity)object3, dialect, ((ArrayList)object10).toArray(new ERForeignKey[((ArrayList)object10).size()]));
                } else {
                    object10 = this._tableDDLGenerator.generateAlterDDL((EREntity)object3, (TableMetadata)object, bl, dialect);
                    for (n5 = 0; n5 < ((String[])object10).length; ++n5) {
                        ((DDLStatementCollection)object5).addTableStatement(object10[n5]);
                    }
                }
                object10 = ((EREntity)object3).indicesIterator();
                while (object10.hasNext()) {
                    iterator2 = (ERIndex)object10.next();
                    object9 = ((ERIndex)((Object)iterator2)).getName();
                    if (object != null && (!((TableMetadata)object).isCanGetIndex() || ((TableMetadata)object).getIndexMetadata((String)object9) != null)) continue;
                    object8 = new IndexInfo((String)object9, ((ERIndex)((Object)iterator2)).isUnique(), ((ERElement)object3).getName(), ((EREntity)object3).getSchema(), ((ERIndex)((Object)iterator2)).getTablespace(), ((ERIndex)((Object)iterator2)).getFunction(), ((ERIndex)((Object)iterator2)).getClustered());
                    object7 = ((ERIndex)((Object)iterator2)).columnIterator();
                    while (object7.hasNext()) {
                        ((IndexInfo)object8).addColumn((ERIndexColumn)object7.next());
                    }
                    stringArray.add(object8);
                }
                if (object != null || !dialect.supportsIndexConstraintInCreateAlterTable()) {
                    iterator2 = ((EREntity)object3).elementIterator();
                    while (iterator2.hasNext()) {
                        object9 = iterator2.next();
                        if (!(object9 instanceof ERColumn) || !((ERColumn)(object8 = (ERColumn)object9)).isIndex()) continue;
                        object7 = ((ERElement)object3).getName() + "_" + ((ERElement)object8).getName();
                        if (object != null && (!((TableMetadata)object).isCanGetIndex() || ((TableMetadata)object).getIndexMetadata((String)object7) != null)) continue;
                        object6 = new IndexInfo((String)object7, ((ERColumn)object8).isUnique(), ((ERElement)object3).getName(), ((EREntity)object3).getSchema(), null, null, 0);
                        ((IndexInfo)object6).addColumn(new ERIndexColumn(((ERElement)object8).getName()));
                        stringArray.add(object6);
                    }
                }
                object10 = ((EREntity)object3).uniqueKeysIterator();
                while (object10.hasNext()) {
                    iterator2 = (String)object10.next();
                    boolean bl3 = false;
                    if (object == null || !((TableMetadata)object).isCanGetIndex()) continue;
                    object8 = ((TableMetadata)object).getIndexMetadata((String)((Object)iterator2));
                    if (object8 != null) {
                        int n6;
                        object7 = ((IndexMetadata)object8).getColumns();
                        object6 = new ArrayList<String>();
                        for (n6 = 0; n6 < ((ColumnMetadata[])object7).length; ++n6) {
                            object6.add(((ColumnMetadata)object7[n6]).getName());
                        }
                        n6 = 1;
                        object4 = ((EREntity)object3).uniqueKeyColumnsIterator((String)((Object)iterator2));
                        while (object4.hasNext()) {
                            void var30_49;
                            String string2 = object4.next();
                            if (eRModel.getQuoteSQLIdentifier() != 2 && !SQLReservedWordChecker.getInstance().isReservedWord(string2)) {
                                if (databaseMetadata.getMeta().storesUpperCaseIdentifiers()) {
                                    String string3 = string2.toUpperCase();
                                } else if (databaseMetadata.getMeta().storesLowerCaseIdentifiers()) {
                                    String string4 = string2.toLowerCase();
                                }
                            }
                            if (object6.remove(var30_49)) continue;
                            n6 = 0;
                            break;
                        }
                        if (n6 != 0) {
                            n6 = object6.isEmpty() ? 1 : 0;
                        }
                        if (n6 != 0) continue;
                        bl3 = true;
                    }
                    object7 = new UniqueKeyInfo((String)((Object)iterator2), ((ERElement)object3).getName(), ((EREntity)object3).getSchema());
                    ((UniqueKeyInfo)object7).setRecreate(bl3);
                    object6 = ((EREntity)object3).uniqueKeyColumnsIterator((String)((Object)iterator2));
                    while (object6.hasNext()) {
                        ((UniqueKeyInfo)object7).addColumn((String)object6.next());
                    }
                    arrayList.add(object7);
                }
                if (object != null) {
                    iterator2 = ((EREntity)object3).elementIterator();
                    while (iterator2.hasNext()) {
                        Object object11;
                        Object object12;
                        ERElement eRElement = iterator2.next();
                        if (!(eRElement instanceof ERColumn) || !((ERColumn)(object8 = (ERColumn)eRElement)).isUnique()) continue;
                        object7 = ((ERElement)object8).getName();
                        if (eRModel.getQuoteSQLIdentifier() != 2 && !SQLReservedWordChecker.getInstance().isReservedWord((String)object7)) {
                            if (databaseMetadata.getMeta().storesUpperCaseIdentifiers()) {
                                object7 = ((String)object7).toUpperCase();
                            } else if (databaseMetadata.getMeta().storesLowerCaseIdentifiers()) {
                                object7 = ((String)object7).toLowerCase();
                            }
                        }
                        boolean bl4 = true;
                        List<String> list = ((TableMetadata)object).getIndexNames();
                        for (String string5 : list) {
                            object12 = ((TableMetadata)object).getIndexMetadata(string5);
                            object11 = ((IndexMetadata)object12).getColumns();
                            if (object11 == null || ((ColumnMetadata[])object11).length != 1 || !object11[0].getName().equals(object7)) continue;
                            bl4 = false;
                            break;
                        }
                        object4 = ((TableMetadata)object).getUniqueConstraintNames();
                        Iterator iterator3 = object4.iterator();
                        while (iterator3.hasNext()) {
                            ColumnMetadata[] columnMetadataArray;
                            object12 = (String)iterator3.next();
                            object11 = ((TableMetadata)object).getUniqueConstraintMetadata((String)object12);
                            if (object11 == null || (columnMetadataArray = ((UniqueConstraintMetadata)object11).getColumns()) == null || columnMetadataArray.length != 1 || !columnMetadataArray[0].getName().equals(object7)) continue;
                            bl4 = false;
                            break;
                        }
                        if (!bl4) continue;
                        UniqueKeyInfo uniqueKeyInfo = new UniqueKeyInfo(null, ((ERElement)object3).getName(), ((EREntity)object3).getSchema());
                        uniqueKeyInfo.addColumn(((ERElement)object8).getName());
                        arrayList.add(uniqueKeyInfo);
                    }
                }
                object10 = this._tableDDLGenerator.generateComment((EREntity)object3, dialect, connection);
                for (n5 = 0; n5 < ((Object)object10).length; ++n5) {
                    ((DDLStatementCollection)object5).addTableStatement((String)object10[n5]);
                }
                progressMonitor.progressUpdate(++n2);
                continue;
            }
            if (!(object42 instanceof ERView)) continue;
            object3 = databaseMetadata.getViewMetadata(object42.getName());
            object2 = ((ERView)object42).getCreateStmt();
            if (object3 == null && object2 != null) {
                ((DDLStatementCollection)object5).addTableStatement((String)object2);
            }
            progressMonitor.progressUpdate(++n2);
        }
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            for (UniqueKeyInfo uniqueKeyInfo : arrayList) {
                if (uniqueKeyInfo.isRecreate()) {
                    if (DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 2) {
                        object3 = new StringBuffer(this.convertKeywordCase("drop index ")).append(DDLGeneratorUtil.quoteName(uniqueKeyInfo.getName(), dialect, n3));
                        ((StringBuffer)object3).append(this.convertKeywordCase(" on ")).append(DDLGeneratorUtil.getQualifiedName(uniqueKeyInfo.getSchema(), uniqueKeyInfo.getEntity(), dialect, n3));
                        ((DDLStatementCollection)object5).addIndexStatement(n4, ((StringBuffer)object3).toString());
                    } else {
                        object3 = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(uniqueKeyInfo.getSchema(), uniqueKeyInfo.getEntity(), dialect, n3)).append(' ');
                        if (this.isFormattedSQL()) {
                            ((StringBuffer)object3).append("\n  ");
                        }
                        ((StringBuffer)object3).append(this.convertKeywordCase("drop constraint "));
                        ((StringBuffer)object3).append(DDLGeneratorUtil.quoteName(uniqueKeyInfo.getName(), dialect, n3));
                        ((DDLStatementCollection)object5).addIndexStatement(n4, ((StringBuffer)object3).toString());
                    }
                }
                object3 = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(uniqueKeyInfo.getSchema(), uniqueKeyInfo.getEntity(), dialect, n3)).append(' ');
                if (this.isFormattedSQL()) {
                    ((StringBuffer)object3).append("\n  ");
                }
                ((StringBuffer)object3).append(this.convertKeywordCase("add "));
                if (dialect.supportConstraintName() && uniqueKeyInfo.getName() != null) {
                    ((StringBuffer)object3).append(this.convertKeywordCase("constraint "));
                    ((StringBuffer)object3).append(DDLGeneratorUtil.quoteName(uniqueKeyInfo.getName(), dialect, n3));
                    ((StringBuffer)object3).append(" ");
                    if (this.isFormattedSQL()) {
                        ((StringBuffer)object3).append("\n    ");
                    }
                }
                ((StringBuffer)object3).append(this.convertKeywordCase("unique ("));
                object2 = uniqueKeyInfo.columnIterator();
                while (object2.hasNext()) {
                    ((StringBuffer)object3).append(DDLGeneratorUtil.quoteName(object2.next(), dialect, n3));
                    if (!object2.hasNext()) continue;
                    ((StringBuffer)object3).append(", ");
                }
                ((StringBuffer)object3).append(")");
                ((DDLStatementCollection)object5).addIndexStatement(((StringBuffer)object3).toString());
            }
        }
        for (IndexInfo indexInfo : stringArray) {
            ((DDLStatementCollection)object5).addIndexStatement(this.generateCreateIndex(dialect, n3, indexInfo));
        }
        stringArray2 = eRModel.elementIterator();
        while (stringArray2.hasNext()) {
            ERElement eRElement = stringArray2.next();
            if (!(eRElement instanceof ERForeignKey)) continue;
            object3 = (ERForeignKey)eRElement;
            object2 = databaseMetadata.getTableMetadata(((ERForeignKey)object3).getReferenceSchema(), ((ERForeignKey)object3).getReferenceTable(), eRModel.getQuoteSQLIdentifier() == 2);
            if (dialect.hasAlterTable() && (object2 == null || ((TableMetadata)object2).getForeignKeyMetadata(((ERElement)object3).getName()) == null) && (object = this._foreignKeyDDLGenerator.generateDDL((ERForeignKey)object3, dialect)) != null) {
                ((DDLStatementCollection)object5).addFKStatement((String)object);
            }
            progressMonitor.progressUpdate(++n2);
        }
        if (!bl2) {
            void var18_28;
            stringArray2 = this.generateTablesForIDGenerator(eRModel, dialect, databaseMetadata, n3);
            boolean bl5 = false;
            while (var18_28 < stringArray2.length) {
                ((DDLStatementCollection)object5).addUnknownStatement(stringArray2[var18_28]);
                ++var18_28;
            }
        }
        stringArray2 = object5;
        return stringArray2;
    }

    public DDLStatementCollection updateDropSchema(ERModel eRModel, Connection connection, Dialect dialect, String string) throws HibernateException, SQLException {
        DDLStatementCollection dDLStatementCollection = new DDLStatementCollection();
        this.updateDropSchema(dDLStatementCollection, eRModel, connection, dialect, string);
        return dDLStatementCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDropSchema(DDLStatementCollection dDLStatementCollection, ERModel eRModel, Connection connection, Dialect dialect, String string) throws HibernateException, SQLException {
        Object object;
        Object object2;
        Object object3;
        List<String> list;
        Object object4;
        String string2;
        EREntity eREntity;
        Object object5;
        DatabaseMetadata databaseMetadata = new DatabaseMetadata(connection, dialect);
        Object object6 = eRModel.elementIterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            if (!(object5 instanceof EREntity)) continue;
            eREntity = (EREntity)object5;
            string2 = eREntity.getSchema();
            if (string2 == null && DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 16) {
                string2 = string;
            }
            if ((object4 = databaseMetadata.getTableMetadata(string2, object5.getName(), eRModel.getQuoteSQLIdentifier() == 2)) == null) continue;
            list = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, eRModel.getQuoteSQLIdentifier())).append(' ');
            if (this.isFormattedSQL()) {
                ((StringBuffer)((Object)list)).append("\n  ");
            }
            object3 = ((TableMetadata)object4).getAllColumnsName();
            for (int i = 0; i < ((String[])object3).length; ++i) {
                boolean i2 = false;
                object2 = eREntity.elementIterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!(object instanceof ERColumn) || !((String)object3[i]).equals(((ERColumn)object).getName().toLowerCase())) continue;
                    i2 = true;
                    break;
                }
                if (i2) continue;
                object = ((TableMetadata)object4).getForeignKeys();
                block5: for (int j = 0; j < ((String[])object).length; ++j) {
                    ForeignKeyMetadata foreignKeyMetadata = ((TableMetadata)object4).getForeignKeyMetadata(object[j]);
                    ColumnMetadata[] columnMetadataArray = foreignKeyMetadata.getColumns();
                    for (int k = 0; k < columnMetadataArray.length; ++k) {
                        if (!((String)object3[i]).equals(columnMetadataArray[k].getName().toLowerCase())) continue;
                        StringBuffer stringBuffer = new StringBuffer(((StringBuffer)((Object)list)).toString().trim());
                        stringBuffer.append(this.convertKeywordCase(dialect.getDropForeignKeyString())).append(DDLGeneratorUtil.quoteName(((TableMetadata)object4).getForeignKeyMetadata(object[j]).getName(), dialect, eRModel.getQuoteSQLIdentifier()));
                        dDLStatementCollection.addFKStatement(stringBuffer.toString());
                        continue block5;
                    }
                }
                StringBuffer stringBuffer = new StringBuffer(((StringBuffer)((Object)list)).toString());
                stringBuffer.append(this.convertKeywordCase(dialect.getDropColumnString())).append(' ').append(DDLGeneratorUtil.quoteName((String)object3[i], dialect, eRModel.getQuoteSQLIdentifier()));
                dDLStatementCollection.addTableStatement(stringBuffer.toString());
            }
        }
        object6 = eRModel.elementIterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            if (!(object5 instanceof EREntity)) continue;
            eREntity = (EREntity)object5;
            string2 = eREntity.getSchema();
            if (string2 == null && dialect instanceof Oracle9Dialect) {
                string2 = string;
            }
            if ((object4 = databaseMetadata.getTableMetadata(string2, object5.getName(), eRModel.getQuoteSQLIdentifier() == 2)) == null || !((TableMetadata)object4).isCanGetIndex()) continue;
            list = ((TableMetadata)object4).getUniqueConstraintNames();
            if (!list.isEmpty()) {
                object3 = eREntity.uniqueKeysIterator();
                block8: while (object3.hasNext()) {
                    String string3 = (String)object3.next();
                    if (list.remove(string3)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        object2 = (String)list.get(i);
                        if (!((String)object2).equalsIgnoreCase(string3)) continue;
                        list.remove(i);
                        continue block8;
                    }
                }
            }
            if (!list.isEmpty()) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    String string4 = (String)list.get(i);
                    UniqueConstraintMetadata stringBuffer = ((TableMetadata)object4).getUniqueConstraintMetadata(string4);
                    if (stringBuffer == null || stringBuffer.getColumns().length != 1 || (object2 = eREntity.getColumnByName(stringBuffer.getColumns()[0].getName())) == null || !((ERColumn)object2).isUnique()) continue;
                    list.remove(string4);
                }
            }
            if (!list.isEmpty()) {
                Iterator<ERIndex> iterator = eREntity.indicesIterator();
                block11: while (iterator.hasNext()) {
                    ERIndex object7 = iterator.next();
                    if (list.remove(object7.getName())) continue;
                    for (int stringBuffer = 0; stringBuffer < list.size(); ++stringBuffer) {
                        object2 = (String)list.get(stringBuffer);
                        if (!((String)object2).equalsIgnoreCase(object7.getName())) continue;
                        list.remove(stringBuffer);
                        continue block11;
                    }
                }
            }
            if (DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 2) {
                for (String k : list) {
                    StringBuffer foreignKeyMetadata = new StringBuffer(this.convertKeywordCase("drop index ")).append(DDLGeneratorUtil.quoteName(k, dialect, eRModel.getQuoteSQLIdentifier()));
                    foreignKeyMetadata.append(this.convertKeywordCase(" on ")).append(DDLGeneratorUtil.getQualifiedName(string2, eREntity.getName(), dialect, eRModel.getQuoteSQLIdentifier()));
                    dDLStatementCollection.addIndexStatement(foreignKeyMetadata.toString());
                }
                continue;
            }
            for (String string3 : list) {
                StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(string2, eREntity.getName(), dialect, eRModel.getQuoteSQLIdentifier())).append(' ');
                if (this.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(this.convertKeywordCase("drop constraint "));
                stringBuffer.append(DDLGeneratorUtil.quoteName(string3, dialect, eRModel.getQuoteSQLIdentifier()));
                dDLStatementCollection.addIndexStatement(stringBuffer.toString());
            }
        }
        object6 = new ArrayList();
        object5 = databaseMetadata.getAllTables(DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 16 ? string : null);
        for (int i = 0; i < ((TableMetadata[])object5).length; ++i) {
            boolean bl = false;
            object4 = object5[i].getName().toLowerCase();
            Iterator<ERElement> iterator = eRModel.elementIterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                if (!(object3 instanceof EREntity) || !((String)object4).equals(((ERElement)object3).getName().toLowerCase())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            for (int j = 0; j < ((TableMetadata[])object5).length; ++j) {
                if (i == j) continue;
                object3 = object5[j].getForeignKeys();
                for (int k = 0; k < ((Object)object3).length; ++k) {
                    ForeignKeyMetadata foreignKeyMetadata = object5[j].getForeignKeyMetadata((String)object3[k]);
                    if (!foreignKeyMetadata.getPkTable().toLowerCase().equals(object5[i].getName().toLowerCase()) || (object2 = this.convertKeywordCase(dialect.getDropForeignKeyString())) == null || dDLStatementCollection.contains((String)(object = this.convertKeywordCase("alter table ") + DDLGeneratorUtil.getQualifiedName(object5[j].getSchema(), object5[j].getName(), dialect, eRModel.getQuoteSQLIdentifier()) + (String)object2 + DDLGeneratorUtil.quoteName(foreignKeyMetadata.getName(), dialect, eRModel.getQuoteSQLIdentifier())))) continue;
                    dDLStatementCollection.addFKStatement((String)object);
                }
            }
            object6.add(object5[i]);
        }
        Iterator iterator = object6.iterator();
        while (iterator.hasNext()) {
            TableMetadata tableMetadata = (TableMetadata)iterator.next();
            object4 = new StringBuffer(this.convertKeywordCase("drop table ")).append(DDLGeneratorUtil.getQualifiedName(tableMetadata.getSchema(), tableMetadata.getName(), dialect, eRModel.getQuoteSQLIdentifier()));
            dDLStatementCollection.addTableStatement(((StringBuffer)object4).toString());
        }
    }

    private String[] generateTablesForIDGenerator(ERModel eRModel, Dialect dialect, DatabaseMetadata databaseMetadata, int n) throws HibernateException, SQLException {
        Object object;
        ERElement eRElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator<ERElement> iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            eRElement = iterator.next();
            if (!(eRElement instanceof ERSequence)) continue;
            object = (ERSequence)eRElement;
            if (((ERSequence)object).getSchema() != null && ((ERSequence)object).getSchema().length() > 0) {
                hashSet.add(((ERSequence)object).getSchema() + "." + ((ERElement)object).getName());
                continue;
            }
            hashSet.add(eRElement.getName());
        }
        iterator = eRModel.elementIterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            eRElement = iterator.next();
            if (!(eRElement instanceof EREntity)) continue;
            object = new ArrayList();
            Object object4 = ((EREntity)eRElement).elementIterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                if (!(object3 instanceof ERColumn) || !((ERColumn)(object2 = (ERColumn)object3)).isPrimaryKey() || ((ERColumn)object2).isForeignKey()) continue;
                ((ArrayList)object).add(object2);
            }
            if (((ArrayList)object).size() != 1 || !this.needTableForGenerator((String)(object3 = DDLGeneratorUtil.getIDGenerator(((ERColumn)(object4 = (ERColumn)((ArrayList)object).get(0))).getIdGenerator(), dialect, DBTypeUtil.isIntType(((ERColumn)object4).getType()))), dialect) || hashSet.contains(object2 = DDLGeneratorUtil.getIDGeneratorKey(((ERColumn)object4).getEntity().getSchema(), ((ERColumn)object4).getEntity().getName(), (String)object3, ((ERColumn)object4).getIdGeneratorKey()))) continue;
            Object object5 = object2;
            if (((String)object5).indexOf(46) > -1) {
                object5 = ((String)object5).substring(((String)object5).lastIndexOf(46) + 1);
            }
            if (databaseMetadata != null && (databaseMetadata.isSequence(object5) || databaseMetadata.isTable(object2))) continue;
            try {
                String[] stringArray = this.generateTableForIDGenerator((String)object3, DDLGeneratorUtil.quoteName((String)object2, dialect, n), DDLGeneratorUtil.getDefaultIDTableColumnName(), dialect);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        arrayList.add(stringArray[i]);
                    }
                }
                hashSet.add(object2);
            }
            catch (HibernateException hibernateException) {
                throw new HibernateException("Error generating table/sequence for ID generator of table " + eRElement.getName(), hibernateException);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean needTableForGenerator(String string, Dialect dialect) {
        return string.equals("hilo") || string.equals("sequence") || string.equals("seqhilo");
    }

    private String[] generateTableForIDGenerator(String string, String string2, String string3, Dialect dialect) throws HibernateException {
        if (string.equals("sequence")) {
            if (dialect.supportsSequences() || dialect instanceof DerbyDialect) {
                String[] stringArray = dialect.getCreateSequenceStrings(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.convertKeywordCase(stringArray[i]);
                    stringArray[i] = stringArray[i].replaceAll(this.convertKeywordCase(string2), string2);
                }
                return stringArray;
            }
            throw new MappingException("Database does not support sequence");
        }
        if (string.equals("hilo") || string.equals("seqhilo")) {
            return new String[]{this.convertKeywordCase("create table ") + string2 + " (" + string3 + " " + dialect.getTypeName(4) + ")", this.convertKeywordCase("insert into ") + string2 + this.convertKeywordCase(" values (0)")};
        }
        return null;
    }

    private String[] dropTableForIDGenerator(String string, String string2, String string3, Dialect dialect) {
        if (string.equals("sequence")) {
            String[] stringArray = dialect.getDropSequenceStrings(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.convertKeywordCase(stringArray[i]);
                stringArray[i] = stringArray[i].replaceAll(this.convertKeywordCase(string2), string2);
            }
            return stringArray;
        }
        if (string.equals("hilo") || string.equals("seqhilo")) {
            StringBuffer stringBuffer = new StringBuffer(this.convertKeywordCase("drop table "));
            if (dialect.supportsIfExistsBeforeTableName()) {
                stringBuffer.append(this.convertKeywordCase("if exists "));
            }
            stringBuffer.append(string2).append(dialect.getCascadeConstraintsString());
            if (dialect.supportsIfExistsAfterTableName()) {
                stringBuffer.append(this.convertKeywordCase(" if exists"));
            }
            return new String[]{stringBuffer.toString()};
        }
        return null;
    }

    public String convertKeywordCase(String string) {
        if (this._upperCaseSQL) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    public void setUpperCaseSQL(boolean bl) {
        this._upperCaseSQL = bl;
    }

    public boolean isUpperCaseSQL() {
        return this._upperCaseSQL;
    }

    public boolean isFormattedSQL() {
        return this._formattedSQL;
    }

    public void setFormattedSQL(boolean bl) {
        this._formattedSQL = bl;
    }
}

