/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLStatementCollection {
    private List<DDLStatement> _allStatements = new ArrayList<DDLStatement>();

    protected void addStatement(DDLStatement dDLStatement) {
        this._allStatements.add(dDLStatement);
    }

    public void addTableStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.TABLE));
    }

    public void addViewStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.VIEW));
    }

    public void addIndexStatement(int n, String string) {
        this._allStatements.add(n, new DDLStatement(string, StatementType.INDEX));
    }

    public void addIndexStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.INDEX));
    }

    public void addPKStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.PK));
    }

    public void addFKStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.FK));
    }

    public void addTriggerStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.TRIGGER));
    }

    public void addProcedureStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.PROCEDURE));
    }

    public void addSequenceStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.SEQUENCE));
    }

    public void addInsertStatement(String string) {
        this._allStatements.add(new DDLStatement(string, StatementType.INSERT));
    }

    public void addUnknownStatement(String string) {
        StatementType statementType = string.toLowerCase().startsWith("create sequence ") ? StatementType.SEQUENCE : StatementType.TABLE;
        this._allStatements.add(new DDLStatement(string, statementType));
    }

    public List<DDLStatement> getAllDDLStatements() {
        return this._allStatements;
    }

    public DDLStatement get(int n) {
        return this._allStatements.get(n);
    }

    public String[] getAllStatements() {
        String[] stringArray = new String[this._allStatements.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this._allStatements.get(i).getStatement();
        }
        return stringArray;
    }

    public int size() {
        return this._allStatements.size();
    }

    public boolean contains(String string) {
        for (DDLStatement dDLStatement : this._allStatements) {
            if (!dDLStatement.getStatement().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addAll(List<DDLStatement> list) {
        for (DDLStatement dDLStatement : list) {
            this.addStatement(dDLStatement);
        }
    }

    public void addAll(DDLStatementCollection dDLStatementCollection) {
        if (dDLStatementCollection != null) {
            this.addAll(dDLStatementCollection.getAllDDLStatements());
        }
    }

    public static class DDLStatement {
        private String _statement;
        private final StatementType _statementType;

        public DDLStatement(String string, StatementType statementType) {
            this._statement = string;
            this._statementType = statementType;
        }

        public String getStatement() {
            return this._statement;
        }

        public StatementType getStatementType() {
            return this._statementType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatementType {
        TABLE,
        PK,
        FK,
        INDEX,
        TRIGGER,
        PROCEDURE,
        SEQUENCE,
        INSERT,
        VIEW;

    }
}

