/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import org.hibernate.dialect.Dialect;
import org.orm.ermodel.ERForeignKey;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.DDLGeneratorUtil;

public class ForeignKeyDDLGenerator {
    private DDLGenerator _ddlGenerator;

    public ForeignKeyDDLGenerator(DDLGenerator dDLGenerator) {
        this._ddlGenerator = dDLGenerator;
    }

    public String generateDDL(ERForeignKey eRForeignKey, Dialect dialect) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = eRForeignKey.getModel().getQuoteSQLIdentifier();
        stringBuffer.append(this._ddlGenerator.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(eRForeignKey.getReferenceSchema(), eRForeignKey.getReferenceTable(), dialect, n2));
        String string = eRForeignKey.getName();
        String[] stringArray = new String[eRForeignKey.getRefColumns().length];
        String[] stringArray2 = new String[eRForeignKey.getColumns().length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = DDLGeneratorUtil.quoteName(eRForeignKey.getRefColumns()[n], dialect, n2);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = DDLGeneratorUtil.quoteName(eRForeignKey.getColumns()[n], dialect, n2);
        }
        String string2 = dialect.getAddForeignKeyConstraintString(DDLGeneratorUtil.quoteName(string, dialect, n2), stringArray2, DDLGeneratorUtil.getQualifiedName(eRForeignKey.getReferencedSchema(), eRForeignKey.getReferencedTable(), dialect, n2), stringArray, false);
        if ((string2 = ForeignKeyDDLGenerator.convertForeignKeyConstraintCase(string2, this._ddlGenerator)) == null) {
            return null;
        }
        stringBuffer.append(string2);
        stringBuffer.append(ForeignKeyDDLGenerator.convertForeignKeyConstraintCase(dialect.getReferenceOnUpdateDeleteString(eRForeignKey.getOnUpdate(), eRForeignKey.getOnDelete()), this._ddlGenerator));
        return stringBuffer.toString();
    }

    public static String convertForeignKeyConstraintCase(String string, DDLGenerator dDLGenerator) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("on update", dDLGenerator.convertKeywordCase("on update"));
        string = string.replaceAll("on delete", dDLGenerator.convertKeywordCase("on delete"));
        string = string.replaceAll("add ", dDLGenerator.convertKeywordCase("add "));
        string = string.replaceAll("index ", dDLGenerator.convertKeywordCase("index "));
        string = string.replaceAll("constraint ", dDLGenerator.convertKeywordCase("constraint "));
        string = string.replaceAll("foreign key ", dDLGenerator.convertKeywordCase("foreign key "));
        string = string.replaceAll("references ", dDLGenerator.convertKeywordCase("references "));
        string = string.replaceAll("ADD ", dDLGenerator.convertKeywordCase("add "));
        string = string.replaceAll("CONSTRAINT ", dDLGenerator.convertKeywordCase("constraint "));
        string = string.replaceAll("FOREIGN KEY ", dDLGenerator.convertKeywordCase("foreign key "));
        string = string.replaceAll("REFERENCES ", dDLGenerator.convertKeywordCase("references "));
        return string;
    }

    public String generateDropSQL(ERForeignKey eRForeignKey, Dialect dialect, String string) {
        String string2 = this._ddlGenerator.convertKeywordCase(dialect.getDropForeignKeyString());
        if (string2 == null) {
            return null;
        }
        int n = eRForeignKey.getModel().getQuoteSQLIdentifier();
        return this._ddlGenerator.convertKeywordCase("alter table ") + DDLGeneratorUtil.getQualifiedName(eRForeignKey.getReferenceSchema(), eRForeignKey.getReferenceTable(), dialect, n) + string2 + DDLGeneratorUtil.quoteName(string, dialect, n);
    }
}

