/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import org.hibernate.dialect.Dialect;
import org.orm.ermodel.ERSequence;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.DialectDBTypeMapper;

public class SequenceDDLGenerator {
    private DDLGenerator _generator;
    private Dialect _dialect;

    public SequenceDDLGenerator(DDLGenerator dDLGenerator) {
        this._generator = dDLGenerator;
    }

    public Dialect getDialect() {
        return this._dialect;
    }

    public void setDialect(Dialect dialect) {
        this._dialect = dialect;
    }

    public String[] generateCreateDDL(ERSequence[] eRSequenceArray, int n) {
        int n2 = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n2 == 16) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.generateOracleSequence(eRSequenceArray[i], n);
            }
            return stringArray;
        }
        if (n2 == 1024) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.generateDB2Sequence(eRSequenceArray[i], n);
            }
            return stringArray;
        }
        if (n2 == 256) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.generatePostgresSequence(eRSequenceArray[i], n);
            }
            return stringArray;
        }
        if (n2 == 0x200000) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.generateSqlServerSequence(eRSequenceArray[i], n);
            }
            return stringArray;
        }
        return null;
    }

    private String generateOracleSequence(ERSequence eRSequence, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("create sequence")).append(" ");
        stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eRSequence.getSchema(), eRSequence.getName(), this._dialect, n));
        if (eRSequence.getStartWith() != null && eRSequence.getStartWith().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("start with")).append(" ").append(eRSequence.getStartWith());
        }
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("nocycle"));
            }
        }
        if (eRSequence.getCache() != null && eRSequence.getCache().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        if (eRSequence.isOrder() != null) {
            if (eRSequence.isOrder().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("order"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("noorder"));
            }
        }
        return stringBuffer.toString();
    }

    private String generateDB2Sequence(ERSequence eRSequence, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("create sequence")).append(" ");
        stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eRSequence.getSchema(), eRSequence.getName(), this._dialect, n));
        stringBuffer.append(" ").append(this._generator.convertKeywordCase("as")).append(" ");
        if (eRSequence.getAsType() != null && eRSequence.getAsType().length() > 0) {
            stringBuffer.append(eRSequence.getAsType());
        } else {
            stringBuffer.append(this._generator.convertKeywordCase("integer"));
        }
        if (eRSequence.getStartWith() != null && eRSequence.getStartWith().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("start with")).append(" ").append(eRSequence.getStartWith());
        }
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no cycle"));
            }
        }
        if (eRSequence.getCache() != null && eRSequence.getCache().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        if (eRSequence.isOrder() != null) {
            if (eRSequence.isOrder().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("order"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no order"));
            }
        }
        return stringBuffer.toString();
    }

    private String generatePostgresSequence(ERSequence eRSequence, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("create sequence")).append(" ");
        stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eRSequence.getSchema(), eRSequence.getName(), this._dialect, n));
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no minvalue"));
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no maxvalue"));
        }
        if (eRSequence.getStartWith() != null && eRSequence.getStartWith().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("start with")).append(" ").append(eRSequence.getStartWith());
        }
        if (eRSequence.getCache() != null && eRSequence.getCache().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no cycle"));
            }
        }
        return stringBuffer.toString();
    }

    private String generateSqlServerSequence(ERSequence eRSequence, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("create sequence")).append(" ");
        stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eRSequence.getSchema(), eRSequence.getName(), this._dialect, n));
        if (eRSequence.getAsType() != null && eRSequence.getAsType().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("as")).append(" ");
            stringBuffer.append(eRSequence.getAsType());
        }
        if (eRSequence.getStartWith() != null && eRSequence.getStartWith().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("start with")).append(" ").append(eRSequence.getStartWith());
        }
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no minvalue"));
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no maxvalue"));
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no cycle"));
            }
        }
        if (eRSequence.getCache() != null && eRSequence.getCache().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        return stringBuffer.toString();
    }

    private String alterOracleSequence(ERSequence eRSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("alter sequence")).append(" ");
        if (eRSequence.getSchema() != null && eRSequence.getSchema().length() > 0) {
            stringBuffer.append(eRSequence.getSchema()).append(".");
        }
        stringBuffer.append(eRSequence.getName());
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("nocycle"));
            }
        }
        if (eRSequence.getCache() != null) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        if (eRSequence.isOrder() != null) {
            if (eRSequence.isOrder().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("order"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("noorder"));
            }
        }
        return stringBuffer.toString();
    }

    private String alterDB2Sequence(ERSequence eRSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("alter sequence")).append(" ");
        if (eRSequence.getSchema() != null && eRSequence.getSchema().length() > 0) {
            stringBuffer.append(eRSequence.getSchema()).append(".");
        }
        stringBuffer.append(eRSequence.getName());
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no cycle"));
            }
        }
        if (eRSequence.getCache() != null) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        if (eRSequence.isOrder() != null) {
            if (eRSequence.isOrder().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("order"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no order"));
            }
        }
        return stringBuffer.toString();
    }

    private String alterPostgresSequence(ERSequence eRSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("alter sequence")).append(" ");
        if (eRSequence.getSchema() != null && eRSequence.getSchema().length() > 0) {
            stringBuffer.append(eRSequence.getSchema()).append(".");
        }
        stringBuffer.append(eRSequence.getName());
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no minvalue"));
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no maxvalue"));
        }
        if (eRSequence.getCache() != null) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no cycle"));
            }
        }
        return stringBuffer.toString();
    }

    private String alterSqlServerSequence(ERSequence eRSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._generator.convertKeywordCase("alter sequence")).append(" ");
        if (eRSequence.getSchema() != null && eRSequence.getSchema().length() > 0) {
            stringBuffer.append(eRSequence.getSchema()).append(".");
        }
        stringBuffer.append(eRSequence.getName());
        if (eRSequence.getIncrementBy() != null && eRSequence.getIncrementBy().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("increment by")).append(" ").append(eRSequence.getIncrementBy());
        }
        if (eRSequence.getMinValue() != null && eRSequence.getMinValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("minvalue")).append(" ").append(eRSequence.getMinValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no minvalue"));
        }
        if (eRSequence.getMaxValue() != null && eRSequence.getMaxValue().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("maxvalue")).append(" ").append(eRSequence.getMaxValue());
        } else {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("no maxvalue"));
        }
        if (eRSequence.isCycle() != null) {
            if (eRSequence.isCycle().booleanValue()) {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("cycle"));
            } else {
                stringBuffer.append(" ").append(this._generator.convertKeywordCase("no cycle"));
            }
        }
        if (eRSequence.getCache() != null && eRSequence.getCache().length() > 0) {
            stringBuffer.append(" ").append(this._generator.convertKeywordCase("cache")).append(" ").append(eRSequence.getCache());
        }
        return stringBuffer.toString();
    }

    public String[] generateDropDDL(ERSequence[] eRSequenceArray, int n) {
        int n2 = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n2 == 16 || n2 == 1024 || n2 == 256 || n2 == 0x200000) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._generator.convertKeywordCase("drop sequence")).append(" ");
                if (eRSequenceArray[i].getSchema() != null && eRSequenceArray[i].getSchema().length() > 0) {
                    stringBuffer.append(eRSequenceArray[i].getSchema()).append(".");
                }
                stringBuffer.append(eRSequenceArray[i].getName());
                stringArray[i] = stringBuffer.toString();
            }
            return stringArray;
        }
        return null;
    }

    public String[] generateUpdateDDL(ERSequence[] eRSequenceArray, int n) {
        int n2 = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n2 == 16) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.alterOracleSequence(eRSequenceArray[i]);
            }
            return stringArray;
        }
        if (n2 == 1024) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.alterDB2Sequence(eRSequenceArray[i]);
            }
            return stringArray;
        }
        if (n2 == 256) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.alterPostgresSequence(eRSequenceArray[i]);
            }
            return stringArray;
        }
        if (n2 == 0x200000) {
            String[] stringArray = new String[eRSequenceArray.length];
            for (int i = 0; i < eRSequenceArray.length; ++i) {
                stringArray[i] = this.alterSqlServerSequence(eRSequenceArray[i]);
            }
            return stringArray;
        }
        return null;
    }
}

