/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SQLiteDialect;
import org.hibernate.dialect.SybaseDialect;
import org.orm.ermodel.ERColumn;
import org.orm.ermodel.ERElement;
import org.orm.ermodel.EREntity;
import org.orm.ermodel.ERForeignKey;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.DDLStatementCollection;
import org.orm.ertodb.DialectDBTypeMapper;
import org.orm.ertodb.ForeignKeyDDLGenerator;
import org.orm.ertodb.metadata.ColumnMetadata;
import org.orm.ertodb.metadata.TableMetadata;
import org.orm.ormtypemapper.DBType;
import org.orm.ormtypemapper.DBTypeUtil;

public class TableDDLGenerator {
    private final DDLGenerator _ddlGenerator;

    public TableDDLGenerator(DDLGenerator dDLGenerator) {
        this._ddlGenerator = dDLGenerator;
    }

    public String[] generateAlterDDL(EREntity eREntity, TableMetadata tableMetadata, boolean bl, Dialect dialect) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getPKCount(eREntity);
        int n2 = eREntity.getModel().getQuoteSQLIdentifier();
        StringBuffer stringBuffer = new StringBuffer(this._ddlGenerator.convertKeywordCase("alter table ")).append(DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n2)).append(' ');
        if (this._ddlGenerator.isFormattedSQL()) {
            stringBuffer.append("\n  ");
        }
        Iterator<ERElement> iterator = eREntity.elementIterator();
        while (iterator.hasNext()) {
            String string;
            CharSequence charSequence;
            ERElement eRElement = iterator.next();
            if (!(eRElement instanceof ERColumn)) continue;
            ERColumn eRColumn = (ERColumn)eRElement;
            ColumnMetadata columnMetadata = tableMetadata.getColumnMetadata(eRColumn.getName());
            int n3 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
            if (columnMetadata == null) {
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString()).append(this._ddlGenerator.convertKeywordCase(dialect.getAddColumnString())).append(' ').append(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2)).append(' ').append(this.getColumnDefinition(eRColumn, n3, dialect, n, false));
                arrayList.add(stringBuffer2.toString());
                continue;
            }
            boolean bl2 = false;
            if (bl && DBTypeUtil.hasLengthSpecifier(n3, DBTypeUtil.getDBTypeByID(eRColumn.getType()))) {
                if (columnMetadata.getColumnSize() != eRColumn.getLength()) {
                    if (!(dialect instanceof SQLServerDialect) || columnMetadata.getColumnSize() != 0x3FFFFFFF && columnMetadata.getColumnSize() != Integer.MAX_VALUE || eRColumn.getLength() != -1) {
                        bl2 = true;
                    }
                } else if (DBTypeUtil.getDBTypeByID(eRColumn.getType()).isDecimal() && columnMetadata.getDecimalDigits() != eRColumn.getScale()) {
                    bl2 = true;
                }
            }
            if (!bl2 && columnMetadata.getNullable().length() > 0) {
                boolean bl3 = eRColumn.isNullable();
                if (columnMetadata.isNullable() != bl3) {
                    charSequence = DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2);
                    String string2 = dialect.getAlterColumnNullableString((String)charSequence, bl3);
                    if (string2 == null) {
                        bl2 = true;
                    } else {
                        arrayList.add(stringBuffer.toString() + string2);
                    }
                }
            }
            if (bl2) {
                string = DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2);
                try {
                    charSequence = new StringBuffer(stringBuffer.toString()).append(dialect.getAlterColumnDefinitionString(string, this.getColumnDefinition(eRColumn, n3, dialect, n, true)));
                    arrayList.add(((StringBuffer)charSequence).toString());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            string = eRColumn.getDefaultValue();
            charSequence = this.removeExtraCharFromDBDefaultValue(columnMetadata.getDefaultValue(), dialect);
            int n4 = DBTypeUtil.getDBTypeByID(eRColumn.getType()).getSqlType();
            if ("".equals(charSequence) && (n4 == 1 || n4 == 12)) {
                charSequence = "''";
            }
            if (eRColumn.isPrimaryKey() || string == null || string.length() <= 0 || string.equals(charSequence)) continue;
            String string3 = this.convertDefaultValue(eRColumn, n3, dialect);
            String string4 = DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2);
            try {
                StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.toString()).append(dialect.getAlterColumnDefaultValueString(string4, string3));
                arrayList.add(stringBuffer3.toString());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getColumnDefinition(ERColumn eRColumn, int n, Dialect dialect, int n2, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer(this.getColumnTypeString(eRColumn, n, dialect));
        if (!(bl && dialect instanceof SQLServerDialect || (string = this.convertDefaultValue(eRColumn, n, dialect)) == null || string.length() <= 0)) {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase(" default ")).append(string);
        }
        if (eRColumn.isNullable()) {
            if (bl && (dialect instanceof Oracle9Dialect || dialect instanceof Oracle8iDialect)) {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" null"));
            } else {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(dialect.getNullColumnString()));
            }
        } else {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase(" not null"));
        }
        if (!bl) {
            if (eRColumn.isUnique() && !eRColumn.isIndex() && dialect.supportsUnique() && (n2 != 1 || !eRColumn.isPrimaryKey())) {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" unique"));
            }
            if (eRColumn.hasCheckConstraint()) {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" check(")).append(eRColumn.getCheckConstraint()).append(")");
            }
            if (this._ddlGenerator.getDdlOption().isGenerateCommment() && (string = eRColumn.getComment()) != null && string.length() > 0) {
                stringBuffer.append(dialect.getColumnComment(string.replaceAll("'", "''")));
            }
        }
        return stringBuffer.toString();
    }

    public void generateCreateDDL(DDLStatementCollection dDLStatementCollection, EREntity eREntity, Dialect dialect, ERForeignKey[] eRForeignKeyArray) throws MappingException {
        String string;
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n;
        boolean bl = this._ddlGenerator.getDdlOption().isSplitDDL();
        if (bl && dialect instanceof SQLiteDialect) {
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer((n = this.getPKCount(eREntity)) > 0 ? this._ddlGenerator.convertKeywordCase(dialect.getCreateTableString()) : this._ddlGenerator.convertKeywordCase(dialect.getCreateMultisetTableString())).append(' ');
        int n2 = eREntity.getModel().getQuoteSQLIdentifier();
        String string2 = DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n2);
        stringBuffer.append(string2);
        stringBuffer.append(" (");
        if (this._ddlGenerator.isFormattedSQL()) {
            stringBuffer.append("\n  ");
        }
        HashMap<Object, Iterator<ERElement>> hashMap = new HashMap<Object, Iterator<ERElement>>();
        int n3 = 0;
        Iterator<ERElement> iterator = eREntity.elementIterator();
        while (iterator.hasNext()) {
            object6 = iterator.next();
            if (!(object6 instanceof ERColumn)) continue;
            object5 = (ERColumn)object6;
            object4 = DDLGeneratorUtil.quoteName(((ERElement)object5).getName(), dialect, n2);
            hashMap.put(object5, (Iterator<ERElement>)object4);
            if (((String)object4).length() <= n3) continue;
            n3 = ((String)object4).length();
        }
        boolean bl2 = false;
        object6 = new ArrayList();
        object5 = eREntity.elementIterator();
        while (object5.hasNext()) {
            int n4;
            object4 = (ERElement)object5.next();
            if (!(object4 instanceof ERColumn)) continue;
            object3 = (ERColumn)object4;
            stringArray = (String)hashMap.get(object3);
            stringBuffer.append((String)stringArray);
            if (this._ddlGenerator.isFormattedSQL()) {
                for (n4 = stringArray.length(); n4 < n3; ++n4) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(' ');
            n4 = DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName());
            if (((ERColumn)object3).isPrimaryKey() && this.isIdentityColumn((ERColumn)object3, dialect) && !((ERColumn)object3).isForeignKey()) {
                if (dialect instanceof MySQLDialect) {
                    bl = false;
                }
                if (dialect.hasDataTypeInIdentityColumn()) {
                    stringBuffer.append(this.getColumnTypeString((ERColumn)object3, n4, dialect));
                }
                object2 = DBTypeUtil.getDBTypeByID(((ERColumn)object3).getType());
                stringBuffer.append(' ').append(this._ddlGenerator.convertKeywordCase(dialect.getIdentityColumnString(((DBType)object2).getSqlType(), ((ERColumn)object3).getIdentitySeed(), ((ERColumn)object3).getIdentityIncrement())));
                if (dialect instanceof SQLiteDialect && ((ERColumn)object3).isPrimaryKey()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" not null"));
                    boolean bl3 = false;
                    object = eREntity.elementIterator();
                    while (object.hasNext()) {
                        ERElement eRElement = (ERElement)object.next();
                        if (eRElement == object4 || !(eRElement instanceof ERColumn) || !((ERColumn)eRElement).isPrimaryKey()) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3 && !bl) {
                        bl2 = true;
                        stringBuffer.append(this._ddlGenerator.convertKeywordCase(" primary key"));
                    }
                }
            } else {
                stringBuffer.append(this.getColumnTypeString((ERColumn)object3, n4, dialect));
                object2 = this.convertDefaultValue((ERColumn)object3, n4, dialect);
                if (object2 != null && ((String)object2).length() > 0) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" default ")).append((String)object2);
                }
                if (((ERColumn)object3).isNullable() && !((ERColumn)object3).isPrimaryKey()) {
                    if (dialect instanceof MySQLDialect) {
                        DBType dBType = DBTypeUtil.getDBTypeByID(((ERColumn)object3).getType());
                        if (dBType.getSqlType() == 93) {
                            stringBuffer.append(this._ddlGenerator.convertKeywordCase(" null"));
                        }
                    } else {
                        stringBuffer.append(this._ddlGenerator.convertKeywordCase(dialect.getNullColumnString()));
                    }
                } else {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" not null"));
                }
            }
            if (!(!((ERColumn)object3).isUnique() || ((ERColumn)object3).isIndex() || n == 1 && ((ERColumn)object3).isPrimaryKey())) {
                if (dialect.supportsUnique()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" unique"));
                } else {
                    ((ArrayList)object6).add(((ERElement)object3).getName());
                }
            }
            if (((ERColumn)object3).hasCheckConstraint() && dialect.supportsColumnCheck()) {
                stringBuffer.append(this._ddlGenerator.convertKeywordCase(" check(")).append(((ERColumn)object3).getCheckConstraint()).append(")");
            }
            if (this._ddlGenerator.getDdlOption().isGenerateCommment() && (object2 = ((ERColumn)object3).getComment()) != null && ((String)object2).length() > 0) {
                stringBuffer.append(dialect.getColumnComment(((String)object2).replaceAll("'", "''")));
            }
            if ((object2 = ((ERColumn)object3).getExtraDDLClause()) != null && ((String)object2).length() > 0) {
                stringBuffer.append(" ").append((String)object2);
            }
            if (!object5.hasNext()) continue;
            stringBuffer.append(", ");
            if (!this._ddlGenerator.isFormattedSQL()) continue;
            stringBuffer.append("\n  ");
        }
        if (!bl2 && !bl) {
            boolean bl4 = false;
            object4 = eREntity.elementIterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                if (!(object3 instanceof ERColumn) || !(stringArray = object3).isPrimaryKey()) continue;
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (!bl4) {
                    String string3 = eREntity.getPkConstraintName();
                    if (dialect.supportConstraintName() && string3 != null) {
                        stringBuffer.append(this._ddlGenerator.convertKeywordCase("constraint "));
                        stringBuffer.append(DDLGeneratorUtil.quoteName(string3, dialect, n2));
                        stringBuffer.append(" ");
                        if (this._ddlGenerator.isFormattedSQL()) {
                            stringBuffer.append("\n    ");
                        }
                    }
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("primary key ("));
                    bl4 = true;
                }
                stringBuffer.append(DDLGeneratorUtil.quoteName(stringArray.getName(), dialect, n2));
            }
            if (bl4) {
                stringBuffer.append(")");
                object4 = eREntity.getPkTablespace();
                if (dialect.supportPrimaryKeyTablespace() && object4 != null && ((String)object4).length() > 0) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase(" using index tablespace ")).append(DDLGeneratorUtil.quoteName((String)object4, dialect, n2));
                }
            }
            bl2 = true;
        }
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            Iterator<String> iterator2 = eREntity.uniqueKeysIterator();
            while (iterator2.hasNext()) {
                object4 = iterator2.next();
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (dialect.supportConstraintName()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("constraint "));
                    stringBuffer.append(DDLGeneratorUtil.quoteName((String)object4, dialect, n2));
                    stringBuffer.append(" ");
                    if (this._ddlGenerator.isFormattedSQL()) {
                        stringBuffer.append("\n    ");
                    }
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("unique ("));
                object3 = eREntity.uniqueKeyColumnsIterator((String)object4);
                while (object3.hasNext()) {
                    ERColumn eRColumn;
                    stringArray = (String)object3.next();
                    if (DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 1024 && (eRColumn = eREntity.getColumnByName((String)stringArray)) != null && eRColumn.isNullable()) {
                        throw new MappingException("DB2 unique constraint \"" + (String)object4 + "\" column \"" + (String)stringArray + "\" cannot nullable.");
                    }
                    stringBuffer.append(DDLGeneratorUtil.quoteName((String)stringArray, dialect, n2));
                    if (!object3.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
            }
            iterator2 = ((ArrayList)object6).iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("unique ("));
                stringBuffer.append(DDLGeneratorUtil.quoteName(iterator2.next(), dialect, n2));
                stringBuffer.append(")");
            }
        }
        if (dialect.supportsIndexConstraintInCreateAlterTable()) {
            Iterator<ERElement> iterator3 = eREntity.elementIterator();
            while (iterator3.hasNext()) {
                object4 = iterator3.next();
                if (!(object4 instanceof ERColumn) || !((ERColumn)(object3 = (ERColumn)object4)).isIndex()) continue;
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (((ERColumn)object3).isUnique()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("unique "));
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("index ("));
                stringBuffer.append(DDLGeneratorUtil.quoteName(((ERElement)object3).getName(), dialect, n2));
                stringBuffer.append(")");
            }
        }
        if (dialect.createForeignKeyInCreateTable() && eRForeignKeyArray != null) {
            for (int i = 0; i < eRForeignKeyArray.length; ++i) {
                object4 = eRForeignKeyArray[i];
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("foreign key("));
                object3 = ((ERForeignKey)object4).getColumns();
                for (int j = 0; j < ((String[])object3).length; ++j) {
                    stringBuffer.append(DDLGeneratorUtil.quoteName(object3[j], dialect, n2));
                    if (j >= ((Object)object3).length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(") ");
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("references "));
                stringBuffer.append(DDLGeneratorUtil.quoteName(((ERForeignKey)object4).getReferencedTable(), dialect, n2));
                stringBuffer.append("(");
                stringArray = ((ERForeignKey)object4).getRefColumns();
                for (int j = 0; j < stringArray.length; ++j) {
                    stringBuffer.append(DDLGeneratorUtil.quoteName(stringArray[j], dialect, n2));
                    if (j >= stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                stringBuffer.append(ForeignKeyDDLGenerator.convertForeignKeyConstraintCase(dialect.getReferenceOnUpdateDeleteString(((ERForeignKey)object4).getOnUpdate(), ((ERForeignKey)object4).getOnDelete()), this._ddlGenerator));
            }
        }
        if (dialect.supportsTableCheck()) {
            Iterator<String> iterator4 = eREntity.checkConstraintKeysIterator();
            while (iterator4.hasNext()) {
                object4 = iterator4.next();
                stringBuffer.append(", ");
                if (this._ddlGenerator.isFormattedSQL()) {
                    stringBuffer.append("\n  ");
                }
                if (dialect.supportConstraintName()) {
                    stringBuffer.append(this._ddlGenerator.convertKeywordCase("constraint "));
                    stringBuffer.append(DDLGeneratorUtil.quoteName((String)object4, dialect, n2));
                    stringBuffer.append(" ");
                    if (this._ddlGenerator.isFormattedSQL()) {
                        stringBuffer.append("\n    ");
                    }
                }
                stringBuffer.append(this._ddlGenerator.convertKeywordCase("check (")).append(eREntity.getCheckConstraints((String)object4)).append(")");
            }
        }
        stringBuffer.append(")");
        if (this._ddlGenerator.getDdlOption().isGenerateCommment() && eREntity.getComment() != null && eREntity.getComment().length() > 0) {
            stringBuffer.append(dialect.getTableComment(eREntity.getComment().replaceAll("'", "''")));
        }
        stringBuffer.append(dialect.getTableTypeString());
        if (dialect instanceof MySQLDialect && (string = eREntity.getModel().getTableCharset()) != null && string.trim().length() > 0) {
            stringBuffer.append(" CHARACTER SET ").append(string);
        }
        String string4 = eREntity.getTablespace();
        object4 = dialect.getCreateTableInTablespaceKeyword();
        if (object4 != null && string4 != null && string4.length() > 0) {
            stringBuffer.append(" ").append(this._ddlGenerator.convertKeywordCase((String)object4)).append(" ").append(string4);
        }
        if (eREntity.getExtraDDLClause() != null && eREntity.getExtraDDLClause().length() > 0) {
            stringBuffer.append(" ").append(eREntity.getExtraDDLClause());
        }
        dDLStatementCollection.addTableStatement(stringBuffer.toString());
        if (bl) {
            object3 = new StringBuffer();
            boolean bl5 = false;
            Object object7 = eREntity.elementIterator();
            while (object7.hasNext()) {
                ERColumn eRColumn;
                object2 = object7.next();
                if (!(object2 instanceof ERColumn) || !(eRColumn = (ERColumn)object2).isPrimaryKey()) continue;
                if (!bl5) {
                    boolean bl6;
                    object = eREntity.getPkConstraintName();
                    ((StringBuffer)object3).append(this._ddlGenerator.convertKeywordCase("alter table "));
                    ((StringBuffer)object3).append(string2);
                    ((StringBuffer)object3).append(this._ddlGenerator.convertKeywordCase(" add "));
                    boolean bl7 = bl6 = dialect.supportConstraintName() && object != null;
                    if (dialect instanceof InformixDialect || bl6) {
                        ((StringBuffer)object3).append(this._ddlGenerator.convertKeywordCase("constraint "));
                    }
                    if (bl6) {
                        ((StringBuffer)object3).append(DDLGeneratorUtil.quoteName((String)object, dialect, n2));
                        ((StringBuffer)object3).append(" ");
                    }
                    ((StringBuffer)object3).append(this._ddlGenerator.convertKeywordCase("primary key ("));
                    ((StringBuffer)object3).append(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2));
                    bl5 = true;
                    continue;
                }
                ((StringBuffer)object3).append(", ");
                ((StringBuffer)object3).append(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n2));
            }
            if (bl5) {
                ((StringBuffer)object3).append(")");
                object7 = eREntity.getPkTablespace();
                if (dialect.supportPrimaryKeyTablespace() && object7 != null && ((String)object7).length() > 0) {
                    ((StringBuffer)object3).append(this._ddlGenerator.convertKeywordCase(" using index tablespace ")).append(DDLGeneratorUtil.quoteName((String)object7, dialect, n2));
                }
                dDLStatementCollection.addPKStatement(((StringBuffer)object3).toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getColumnTypeString(ERColumn eRColumn, int n, Dialect dialect) {
        String string;
        String string2;
        String string3 = eRColumn.getUserType(n);
        if (string3 != null) {
            return string3;
        }
        DBType dBType = DBTypeUtil.getDBTypeByID(eRColumn.getType());
        String string4 = dBType.getDBType(n);
        if (n == 64) {
            if (this.isSybaseIdentityColumn(eRColumn, n, dialect)) {
                return "numeric(19,0)";
            }
        } else if (n == 2048 && string4.equals("informix_float")) {
            string4 = "float";
        }
        if (!DBTypeUtil.hasLengthSpecifier(n, dBType)) return string4;
        int n2 = eRColumn.getLength();
        if (n2 == 0 && !DBTypeUtil.isAllowZeroLength(n, dBType)) {
            n2 = DBTypeUtil.generateDefaultLength(n, dBType);
        }
        if (n2 == 0) return string4;
        if (n2 == -1) {
            string2 = dBType.getDBTypeName(n);
            if (!("varchar".equals(string2) || "varchar2".equals(string2) || "nvarchar".equals(string2) || "nvarchar2".equals(string2))) {
                if (!"varbinary".equals(string2)) return string4;
            }
            string = n == 8 ? "max" : (n == 0x200000 ? "max" : "255");
        } else {
            string = String.valueOf(n2);
        }
        string2 = "(";
        string2 = string2 + string;
        if (dBType.isDecimal()) {
            string2 = string2 + ", " + eRColumn.getScale();
        }
        string2 = string2 + ")";
        if (string4.indexOf("($l)") <= 0) return string4 + string2;
        return string4.replaceFirst("\\(\\$l\\)", string2);
    }

    private boolean isSybaseIdentityColumn(ERColumn eRColumn, int n, Dialect dialect) {
        ERColumn eRColumn2;
        DBType dBType = DBTypeUtil.getDBTypeByID(eRColumn.getType());
        String string = dBType.getDBType(n);
        if (eRColumn.isPrimaryKey() && !string.equals("numeric") && this.isIdentityColumn(eRColumn, dialect)) {
            return true;
        }
        if (eRColumn.isForeignKey() && (eRColumn2 = eRColumn.getModel().getColumnByFullName(eRColumn.getReferencedColumn())) != null) {
            return this.isSybaseIdentityColumn(eRColumn2, n, dialect);
        }
        return false;
    }

    private boolean isIdentityColumn(ERColumn eRColumn, Dialect dialect) {
        String string = DDLGeneratorUtil.getIDGenerator(eRColumn.getIdGenerator(), dialect, DBTypeUtil.isIntType(eRColumn.getType()));
        return string != null && string.equals("identity");
    }

    private int getPKCount(EREntity eREntity) {
        int n = 0;
        Iterator<ERElement> iterator = eREntity.elementIterator();
        while (iterator.hasNext()) {
            ERColumn eRColumn = (ERColumn)iterator.next();
            if (!eRColumn.isPrimaryKey()) continue;
            ++n;
        }
        return n;
    }

    public String generateDropSQL(EREntity eREntity, Dialect dialect) {
        int n = eREntity.getModel().getQuoteSQLIdentifier();
        StringBuffer stringBuffer = new StringBuffer(this._ddlGenerator.convertKeywordCase("drop table "));
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase("if exists "));
        }
        stringBuffer.append(DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n)).append(this._ddlGenerator.convertKeywordCase(dialect.getCascadeConstraintsString()));
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(this._ddlGenerator.convertKeywordCase(" if exists"));
        }
        return stringBuffer.toString();
    }

    public String convertDefaultValue(ERColumn eRColumn, int n, Dialect dialect) {
        DBType dBType;
        int n2;
        String string = eRColumn.getDefaultValue();
        if (string != null && string.length() > 0 && (n2 = (dBType = DBTypeUtil.getDBTypeByID(eRColumn.getType())).getTypeGroup()) != 3 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7 && n2 != 2 && n2 != 1 && n2 != 9 && n2 != 15 && n2 != 10 && !"uniqueidentifier".equals(dBType.getDBType(n))) {
            if (n2 == 0 && (n == 2 || n == 0x100000)) {
                return string;
            }
            if (n2 == 0 && (n == 8 || n == 1024) && ("0".equals(string) || "1".equals(string))) {
                return string;
            }
            if (n2 == 0 && (n == 512 || n == 16)) {
                if (string.toLowerCase().equals("true")) {
                    return "1";
                }
                if (string.toLowerCase().equals("false")) {
                    return "0";
                }
            }
            if (string.startsWith("'") || string.endsWith("'")) {
                return string;
            }
            String string2 = string.toLowerCase();
            if (string2.indexOf(40) > 0) {
                string2 = string2.substring(0, string2.indexOf(40));
            }
            if (dialect.getFunctions().containsKey(string2.toLowerCase().trim())) {
                return string;
            }
            if (!string.trim().startsWith("'")) {
                string = "'" + string;
            }
            if (!string.trim().endsWith("'")) {
                string = string + "'";
            }
        }
        return string;
    }

    private String removeExtraCharFromDBDefaultValue(String string, Dialect dialect) {
        String string2 = string;
        if (string2 != null && string2.length() > 0) {
            if (dialect instanceof PostgreSQLDialect) {
                if (string2.endsWith("::character varying")) {
                    string2 = string2.replaceAll("::character varying", "");
                    string2 = string2.replaceAll("\\\\'", "'");
                    string2 = string2.substring(1, string2.length() - 1);
                }
            } else if (dialect instanceof SQLServerDialect) {
                if (string2.startsWith("('") && string2.endsWith("')")) {
                    string2 = string2.substring(2, string2.length() - 2);
                    string2 = string2.replaceAll("''", "'");
                } else if (string2.startsWith("((") && string2.endsWith("))")) {
                    string2 = string2.substring(2, string2.length() - 2);
                } else if (string2.startsWith("(") && string2.endsWith(")")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
            } else if ((dialect instanceof DB2Dialect || dialect instanceof HSQLDialect || dialect instanceof Oracle9Dialect || dialect instanceof SybaseDialect) && string2.startsWith("'") && string2.endsWith("'")) {
                string2 = string2.substring(1, string2.length() - 1);
                string2 = string2.replaceAll("''", "'");
            }
        }
        return string2;
    }

    public String[] generateComment(EREntity eREntity, Dialect dialect, Connection connection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._ddlGenerator.getDdlOption().isGenerateCommment() && dialect.supportsCommentOn()) {
            Object object;
            int n = eREntity.getModel().getQuoteSQLIdentifier();
            String string = DDLGeneratorUtil.getQualifiedName(eREntity.getSchema(), eREntity.getName(), dialect, n);
            String string2 = eREntity.getComment();
            if (string2 != null && string2.length() > 0) {
                string2 = string2.replaceAll("'", "''");
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(string2, eREntity.getSchema(), eREntity.getName(), null, connection));
                } else {
                    object = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("comment on table ")).append(string).append(this._ddlGenerator.convertKeywordCase(" is '")).append(string2).append("'");
                    arrayList.add(((StringBuffer)object).toString());
                }
            }
            object = eREntity.elementIterator();
            while (object.hasNext()) {
                ERColumn eRColumn;
                String string3;
                ERElement eRElement = object.next();
                if (!(eRElement instanceof ERColumn) || (string3 = (eRColumn = (ERColumn)eRElement).getComment()) == null || string3.length() <= 0) continue;
                string3 = string3.replaceAll("'", "''");
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(string3, eREntity.getSchema(), eREntity.getName(), eRColumn.getName(), connection));
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("comment on column ")).append(string).append('.').append(DDLGeneratorUtil.quoteName(eRColumn.getName(), dialect, n)).append(this._ddlGenerator.convertKeywordCase(" is '")).append(string3).append("'");
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String generateSqlServerComment(String string, String string2, String string3, String string4, Connection connection) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            string2 = "dbo";
        }
        boolean bl = false;
        if (connection != null) {
            try {
                ResultSet resultSet;
                object = connection.createStatement();
                String string5 = "NULL";
                String string6 = "NULL";
                if (string4 != null) {
                    string5 = "'column'";
                    string6 = "'" + string4 + "'";
                }
                if ((resultSet = object.executeQuery("select count(*) from fn_listextendedproperty ('MS_Description', 'schema', '" + string2 + "', 'table', '" + string3 + "', " + string5 + ", " + string6 + ");")).next() && resultSet.getInt(1) > 0) {
                    bl = true;
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        object = new StringBuffer().append(this._ddlGenerator.convertKeywordCase("exec "));
        if (bl) {
            ((StringBuffer)object).append("sp_updateextendedproperty ");
        } else {
            ((StringBuffer)object).append("sp_addextendedproperty ");
        }
        if (this._ddlGenerator.isFormattedSQL()) {
            ((StringBuffer)object).append("\n  ");
        }
        ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@name = ")).append("N'MS_Description', ").append(this._ddlGenerator.convertKeywordCase("@value = '")).append(string.replaceAll("\n", "\r\n")).append("', ");
        if (this._ddlGenerator.isFormattedSQL()) {
            ((StringBuffer)object).append("\n  ");
        }
        ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@level0type = ")).append("N'Schema', ").append(this._ddlGenerator.convertKeywordCase("@level0name = '")).append(string2).append("', ");
        if (this._ddlGenerator.isFormattedSQL()) {
            ((StringBuffer)object).append("\n  ");
        }
        ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@level1type = ")).append("N'Table', ").append(this._ddlGenerator.convertKeywordCase("@level1name = '")).append(string3).append("'");
        if (string4 != null) {
            ((StringBuffer)object).append(", ");
            if (this._ddlGenerator.isFormattedSQL()) {
                ((StringBuffer)object).append("\n  ");
            }
            ((StringBuffer)object).append(this._ddlGenerator.convertKeywordCase("@level2type = ")).append("N'Column', ").append(this._ddlGenerator.convertKeywordCase("@level2name = '")).append(string4).append("'");
        }
        return ((StringBuffer)object).toString();
    }
}

