/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb;

import org.hibernate.dialect.Dialect;
import org.orm.ermodel.ERView;
import org.orm.ertodb.DDLGenerator;
import org.orm.ertodb.DDLGeneratorUtil;
import org.orm.ertodb.DialectDBTypeMapper;

public class ViewDDLGenerator {
    private final DDLGenerator _generator;

    public ViewDDLGenerator(DDLGenerator dDLGenerator) {
        this._generator = dDLGenerator;
    }

    public String generateDropSQL(ERView eRView, Dialect dialect) {
        int n = eRView.getModel().getQuoteSQLIdentifier();
        StringBuffer stringBuffer = new StringBuffer();
        if (eRView.isMaterialized() && DialectDBTypeMapper.instance().getDBType(dialect.getClass().getName()) == 16) {
            stringBuffer.append(this._generator.convertKeywordCase("drop materialized view "));
        } else {
            stringBuffer.append(this._generator.convertKeywordCase("drop view "));
        }
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append(this._generator.convertKeywordCase("if exists "));
        }
        stringBuffer.append(DDLGeneratorUtil.quoteName(eRView.getName(), dialect, n));
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(this._generator.convertKeywordCase(" if exists"));
        }
        return stringBuffer.toString();
    }
}

