/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;

public class ColumnMetadata {
    private final String name;
    private final String typeName;
    private final int columnSize;
    private final int decimalDigits;
    private final String isNullable;
    private final String defaultValue;

    ColumnMetadata(ResultSet resultSet) throws SQLException {
        this.defaultValue = resultSet.getString("COLUMN_DEF");
        this.name = resultSet.getString("COLUMN_NAME");
        this.typeName = resultSet.getString("TYPE_NAME");
        this.columnSize = resultSet.getInt("COLUMN_SIZE");
        this.decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
        this.isNullable = resultSet.getString("IS_NULLABLE");
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getNullable() {
        return this.isNullable;
    }

    public boolean isNullable() {
        return "YES".equals(this.isNullable);
    }

    public String toString() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

