/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ertodb.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SybaseDialect;
import org.orm.ORMDatabaseInitiator;
import org.orm.ertodb.DialectDBTypeMapper;
import org.orm.ertodb.metadata.ColumnMetadata;
import org.orm.ertodb.metadata.ForeignKeyMetadata;
import org.orm.ertodb.metadata.IndexMetadata;
import org.orm.ertodb.metadata.UniqueConstraintMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetadata {
    private static Log log = LogFactory.getLog(ORMDatabaseInitiator.class);
    private String catalog;
    private final String schema;
    private final String name;
    private final Map<String, ColumnMetadata> columns = new HashMap<String, ColumnMetadata>();
    private final Map<String, ForeignKeyMetadata> foreignKeys = new HashMap<String, ForeignKeyMetadata>();
    private final Map<String, IndexMetadata> indexes = new HashMap<String, IndexMetadata>();
    private final List<String> indexNames = new ArrayList<String>();
    private final Dialect _dialect;
    private final Connection _connection;
    private boolean _canGetIndex = true;

    TableMetadata(ResultSet resultSet, DatabaseMetaData databaseMetaData, Connection connection, Dialect dialect) throws SQLException {
        this._connection = connection;
        this._dialect = dialect;
        this.catalog = resultSet.getString("TABLE_CAT");
        this.schema = resultSet.getString("TABLE_SCHEM");
        this.name = resultSet.getString("TABLE_NAME");
        this.initColumns(databaseMetaData);
        try {
            this.initIndexes(databaseMetaData);
        }
        catch (SQLException sQLException) {
            this._canGetIndex = false;
            log.warn("Cannot get index");
        }
        try {
            this.initForeignKeys(databaseMetaData);
        }
        catch (SQLException sQLException) {
            log.warn("Cannot resolve foreign key contents");
        }
    }

    public boolean isCanGetIndex() {
        return this._canGetIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForeignKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getImportedKeys(null, this.schema, this.name);
            while (resultSet.next()) {
                this.addForeignKey(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public ColumnMetadata getColumnMetadata(String string) {
        return this.columns.get(string.toLowerCase());
    }

    public String[] getAllColumnsName() {
        return this.columns.keySet().toArray(new String[this.columns.size()]);
    }

    public void addColumn(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("COLUMN_NAME");
        if (string == null) {
            return;
        }
        if (this.getColumnMetadata(string) == null) {
            ColumnMetadata columnMetadata = new ColumnMetadata(resultSet);
            this.columns.put(columnMetadata.getName().toLowerCase(), columnMetadata);
        }
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String string) {
        return this.foreignKeys.get(string.toUpperCase());
    }

    public String[] getForeignKeys() {
        return this.foreignKeys.keySet().toArray(new String[this.foreignKeys.size()]);
    }

    public IndexMetadata getIndexMetadata(String string) {
        return this.indexes.get(string.toLowerCase());
    }

    private void addForeignKey(ResultSet resultSet) throws SQLException {
        Object object;
        String string = resultSet.getString("FK_NAME");
        String string2 = resultSet.getString("PKTABLE_NAME");
        String string3 = resultSet.getString("PKTABLE_SCHEM");
        if (string == null && this._dialect instanceof SybaseDialect) {
            object = this._connection.prepareStatement("select o.name as FK_NAME from sysreferences r left join syscolumns c on c.id = r.tableid and c.colid = r.fokey1 left join sysobjects o on r.constrid = o.id left join sysobjects o2 on r.tableid = o2.id where c.name = ? and o2.name = ?");
            object.setString(1, resultSet.getString("FKCOLUMN_NAME"));
            object.setString(2, this.name);
            ResultSet resultSet2 = object.executeQuery();
            if (resultSet2.next()) {
                string = resultSet2.getString("FK_NAME");
            }
            resultSet2.close();
            object.close();
        }
        if (string == null) {
            return;
        }
        object = this.getForeignKeyMetadata(string);
        if (object == null) {
            object = new ForeignKeyMetadata(string, string2, string3);
            this.foreignKeys.put(((ForeignKeyMetadata)object).getName().toUpperCase(), (ForeignKeyMetadata)object);
        }
        ((ForeignKeyMetadata)object).addColumn(this.getColumnMetadata(resultSet.getString("FKCOLUMN_NAME")));
    }

    private void addIndex(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("INDEX_NAME");
        if (string == null) {
            return;
        }
        IndexMetadata indexMetadata = this.getIndexMetadata(string);
        if (indexMetadata == null) {
            indexMetadata = new IndexMetadata(resultSet);
            this.indexes.put(indexMetadata.getName().toLowerCase(), indexMetadata);
            this.indexNames.add(indexMetadata.getName());
        }
        indexMetadata.addColumn(this.getColumnMetadata(resultSet.getString("COLUMN_NAME")));
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getColumns(null, this.getSchema(), this.getName(), "%");
            while (resultSet.next()) {
                this.addColumn(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexes(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getIndexInfo(this.catalog, this.schema, this.name, false, true);
            while (resultSet.next()) {
                if (resultSet.getShort("TYPE") == 0) continue;
                this.addIndex(resultSet);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public List<String> getIndexNames() {
        return new ArrayList<String>(this.indexNames);
    }

    public List<String> getUniqueConstraintNames() {
        int n = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n == 8) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'UNIQUE' and TABLE_NAME = ?");
                preparedStatement.setString(1, this.name);
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("CONSTRAINT_NAME"));
                }
                resultSet.close();
                preparedStatement.close();
                return arrayList;
            }
            catch (Exception exception) {
                log.warn(exception);
            }
        } else if (DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName()) == 16) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select constraint_name from user_constraints where constraint_type = 'U' and table_name = ?");
                preparedStatement.setString(1, this.name);
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("constraint_name"));
                }
                resultSet.close();
                preparedStatement.close();
                return arrayList;
            }
            catch (Exception exception) {
                log.warn(exception);
            }
        } else if (DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName()) == 2) {
            List<String> list = this.getIndexNames();
            if (!list.isEmpty()) {
                String[] stringArray = this.getForeignKeys();
                block6: for (int i = 0; i < stringArray.length; ++i) {
                    for (int j = 0; j < list.size(); ++j) {
                        if (!list.get(j).equalsIgnoreCase(stringArray[i])) continue;
                        list.remove(j);
                        continue block6;
                    }
                }
            }
            list.remove("PRIMARY");
            return list;
        }
        return new ArrayList<String>();
    }

    public UniqueConstraintMetadata getUniqueConstraintMetadata(String string) {
        int n = DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName());
        if (n == 8) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select COLUMN_NAME from INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE where TABLE_NAME = ? and CONSTRAINT_NAME = ?");
                preparedStatement.setString(1, this.name);
                preparedStatement.setString(2, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                UniqueConstraintMetadata uniqueConstraintMetadata = new UniqueConstraintMetadata(string);
                while (resultSet.next()) {
                    uniqueConstraintMetadata.addColumn(this.getColumnMetadata(resultSet.getString("COLUMN_NAME")));
                }
                resultSet.close();
                preparedStatement.close();
                return uniqueConstraintMetadata;
            }
            catch (Exception exception) {
                log.warn(exception);
            }
        } else if (DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName()) == 16) {
            try {
                PreparedStatement preparedStatement = this._connection.prepareStatement("select column_name from user_cons_columns where table_name = ? and constraint_name = ? order by position");
                preparedStatement.setString(1, this.name);
                preparedStatement.setString(2, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                UniqueConstraintMetadata uniqueConstraintMetadata = new UniqueConstraintMetadata(string);
                while (resultSet.next()) {
                    uniqueConstraintMetadata.addColumn(this.getColumnMetadata(resultSet.getString("column_name")));
                }
                resultSet.close();
                preparedStatement.close();
                return uniqueConstraintMetadata;
            }
            catch (Exception exception) {
                log.warn(exception);
            }
        } else if (DialectDBTypeMapper.instance().getDBType(this._dialect.getClass().getName()) == 2) {
            IndexMetadata indexMetadata = this.getIndexMetadata(string);
            UniqueConstraintMetadata uniqueConstraintMetadata = new UniqueConstraintMetadata(indexMetadata.getName());
            ColumnMetadata[] columnMetadataArray = indexMetadata.getColumns();
            for (int i = 0; i < columnMetadataArray.length; ++i) {
                uniqueConstraintMetadata.addColumn(columnMetadataArray[i]);
            }
        }
        return null;
    }
}

