/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ormtypemapper;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.orm.ormtypemapper.DBType;
import org.orm.ormtypemapper.DBTypeInitializer;

public class DBTypeRepository {
    private DBType[] _dbTypes = null;
    private Map _dbTypesMap = null;
    private Map _javaFullTypesMap = null;
    private Map _javaFullToShortTypesMap = null;
    private static DBTypeRepository _instance = null;

    private DBTypeRepository() {
        this.initDBTypes();
    }

    private void initDBTypes() {
        this._dbTypes = DBTypeInitializer.initDBType();
        this._dbTypesMap = new Hashtable();
        for (int i = 0; i < this._dbTypes.length; ++i) {
            this._dbTypesMap.put(new Integer(this._dbTypes[i].getId()), this._dbTypes[i]);
        }
        this._javaFullTypesMap = new Hashtable();
        this._javaFullTypesMap.put("Date", "java.util.Date");
        this._javaFullTypesMap.put("Time", "java.sql.Time");
        this._javaFullTypesMap.put("Timestamp", "java.sql.Timestamp");
        this._javaFullTypesMap.put("BigDecimal", "java.math.BigDecimal");
        this._javaFullTypesMap.put("Clob", "java.sql.Clob");
        this._javaFullTypesMap.put("Blob", "java.sql.Blob");
        this._javaFullTypesMap.put("UUID", "java.util.UUID");
        this._javaFullToShortTypesMap = new Hashtable();
        Iterator iterator = this._javaFullTypesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this._javaFullToShortTypesMap.put(entry.getValue(), entry.getKey());
        }
        this._javaFullToShortTypesMap.put("java.sql.Date", "Date");
        this._javaFullToShortTypesMap.put("java.lang.Long", "Long");
        this._javaFullToShortTypesMap.put("java.lang.Byte", "Byte");
        this._javaFullToShortTypesMap.put("java.lang.Short", "Short");
        this._javaFullToShortTypesMap.put("java.lang.Integer", "Integer");
        this._javaFullToShortTypesMap.put("java.lang.Long", "Long");
        this._javaFullToShortTypesMap.put("java.lang.Float", "Float");
        this._javaFullToShortTypesMap.put("java.lang.Double", "Double");
        this._javaFullToShortTypesMap.put("java.lang.Character", "Character");
        this._javaFullToShortTypesMap.put("java.lang.Boolean", "Boolean");
    }

    static synchronized DBTypeRepository instance() {
        if (_instance == null) {
            _instance = new DBTypeRepository();
        }
        return _instance;
    }

    DBType[] getDBTypes() {
        return this._dbTypes;
    }

    Map getDBTypesMap() {
        return this._dbTypesMap;
    }

    String getJavaFullType(String string) {
        Object v = this._javaFullTypesMap.get(string);
        if (v == null) {
            return string;
        }
        return (String)v;
    }

    String getJavaShortType(String string) {
        Object v = this._javaFullToShortTypesMap.get(string);
        if (v == null) {
            return string;
        }
        return (String)v;
    }
}

