/*
 * Decompiled with CFR 0.152.
 */
package org.orm.ormtypemapper;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.orm.ormtypemapper.DBType;
import org.orm.ormtypemapper.DBTypeRepository;

public class DBTypeUtil {
    private static Hashtable JDBC_TYPE_NAME_MAP = new Hashtable();

    public static DBType[] getDBTypes() {
        DBType[] dBTypeArray = DBTypeRepository.instance().getDBTypes();
        DBType[] dBTypeArray2 = new DBType[dBTypeArray.length];
        System.arraycopy(dBTypeArray, 0, dBTypeArray2, 0, dBTypeArray.length);
        return dBTypeArray2;
    }

    public static DBType getDBTypeByID(int n) {
        Map map = DBTypeRepository.instance().getDBTypesMap();
        return (DBType)map.get(new Integer(n));
    }

    public static DBType getDBTypeByJava(String string, String string2) {
        int n;
        String string3 = string;
        if (string.equals("byte") && string2 != null && string2.length() > 0) {
            string3 = string3 + string2;
        }
        DBType[] dBTypeArray = DBTypeUtil.getDBTypes();
        for (n = 0; n < dBTypeArray.length; ++n) {
            String string4 = dBTypeArray[n].getJavaType();
            if (!DBTypeUtil.getJavaShortType(string3).equalsIgnoreCase(string4)) continue;
            return dBTypeArray[n];
        }
        for (n = 0; n < dBTypeArray.length; ++n) {
            if (!dBTypeArray[n].getJavaWrapperType().equalsIgnoreCase(string3) && !dBTypeArray[n].getJavaWrapperType().equalsIgnoreCase(DBTypeUtil.getJavaShortType(string3))) continue;
            return dBTypeArray[n];
        }
        return null;
    }

    public static DBType[] getDBTypesByJava(String string, String string2) {
        int n;
        ArrayList<DBType> arrayList = new ArrayList<DBType>();
        String string3 = string;
        if (string.equals("byte") && string2 != null && string2.length() > 0) {
            string3 = string3 + string2;
        }
        DBType[] dBTypeArray = DBTypeUtil.getDBTypes();
        for (n = 0; n < dBTypeArray.length; ++n) {
            String string4 = dBTypeArray[n].getJavaType();
            if (!DBTypeUtil.getJavaShortType(string3).equalsIgnoreCase(string4) || arrayList.contains(dBTypeArray[n])) continue;
            arrayList.add(dBTypeArray[n]);
        }
        for (n = 0; n < dBTypeArray.length; ++n) {
            if (!dBTypeArray[n].getJavaWrapperType().equalsIgnoreCase(string3) || arrayList.contains(dBTypeArray[n])) continue;
            arrayList.add(dBTypeArray[n]);
        }
        return arrayList.toArray(new DBType[arrayList.size()]);
    }

    public static DBType getDBTypeByHibernate(String string) {
        DBType[] dBTypeArray = DBTypeUtil.getDBTypes();
        for (int i = 0; i < dBTypeArray.length; ++i) {
            if (!dBTypeArray[i].getHibernateType().equalsIgnoreCase(string)) continue;
            return dBTypeArray[i];
        }
        return null;
    }

    public static DBType getDBTypeByNHibernate(String string) {
        DBType[] dBTypeArray = DBTypeUtil.getDBTypes();
        for (int i = 0; i < dBTypeArray.length; ++i) {
            if (!dBTypeArray[i].getNHibernateType().equalsIgnoreCase(string)) continue;
            return dBTypeArray[i];
        }
        return null;
    }

    public static DBType getDBTypeByDB(int n, String string, int n2, int n3) {
        DBType dBType = null;
        DBType dBType2 = null;
        DBType dBType3 = null;
        string = string.trim();
        if (n == 2048) {
            if (string.equals("float")) {
                string = "informix_float";
            } else if (string.equals("datetime")) {
                if (n2 == 1642) {
                    string = "datetime hour to second";
                    n2 = 0;
                } else if (n2 == 4879) {
                    string = "datetime year to fraction";
                    n2 = 5;
                }
            }
        }
        DBType[] dBTypeArray = DBTypeUtil.getDBTypes();
        int[] nArray = new int[]{n, 1};
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            for (int j = 0; j < dBTypeArray.length; ++j) {
                String string2 = dBTypeArray[j].getDBType(n4);
                String string3 = dBTypeArray[j].getDBTypeName(n4);
                if (!string2.equalsIgnoreCase(string) && !string3.equalsIgnoreCase(string) || !dBTypeArray[j].isDecimal() && n3 != 0) continue;
                int n5 = dBTypeArray[j].getDBLength(n4);
                if (n5 == n2) {
                    return dBTypeArray[j];
                }
                if (n5 == -1) {
                    if (dBType2 != null) continue;
                    dBType2 = dBTypeArray[j];
                    continue;
                }
                if (n5 > n2) {
                    if (dBType == null) {
                        dBType = dBTypeArray[j];
                        continue;
                    }
                    if (n2 != 0 && dBType.getDBLength(n4) > n5) {
                        dBType = dBTypeArray[j];
                        continue;
                    }
                    if (n2 != 0 || n5 <= dBType.getDBLength(n4)) continue;
                    dBType = dBTypeArray[j];
                    continue;
                }
                if (dBType3 != null && n5 <= dBType3.getDBLength(n4)) continue;
                dBType3 = dBTypeArray[j];
            }
            if (dBType2 != null) {
                return dBType2;
            }
            if (dBType != null) {
                return dBType;
            }
            if (dBType3 == null) continue;
            return dBType3;
        }
        if (n3 == 0) {
            return null;
        }
        return DBTypeUtil.getDBTypeByDB(n, string, n2, 0);
    }

    public static DBType getDBTypeBySQLType(int n) {
        DBType[] dBTypeArray = DBTypeUtil.getDBTypes();
        for (int i = 0; i < dBTypeArray.length; ++i) {
            if (dBTypeArray[i].getSqlType() != n) continue;
            return dBTypeArray[i];
        }
        return null;
    }

    public static DBType getIntDBType() {
        return DBTypeUtil.getDBTypeByJava("int", null);
    }

    public static boolean isIntType(int n) {
        DBType dBType = DBTypeUtil.getDBTypeByID(n);
        return dBType.getTypeGroup() == 4 || dBType.getTypeGroup() == 3 || dBType.getTypeGroup() == 2 || dBType.getTypeGroup() == 1;
    }

    public static boolean isNumericType(int n) {
        DBType dBType = DBTypeUtil.getDBTypeByID(n);
        switch (dBType.getTypeGroup()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static String getJavaFullType(String string) {
        return DBTypeRepository.instance().getJavaFullType(string);
    }

    public static String getJavaShortType(String string) {
        return DBTypeRepository.instance().getJavaShortType(string);
    }

    public static String getJDBCTypeName(int n) {
        return (String)JDBC_TYPE_NAME_MAP.get(new Integer(n));
    }

    public static boolean isUniqueIdentifier(int n) {
        return n == 48;
    }

    public static int generateDefaultLength(int n, DBType dBType) {
        int n2 = dBType.getDBLength(n);
        if (n2 == -1) {
            int n3 = dBType.getDefaultLength();
            if (dBType.getTypeGroup() == 7 && n == 16384 && n3 > 18) {
                return 18;
            }
            if (n == 1024 && "char".equals(dBType.getDBType(n))) {
                return 254;
            }
            return n3;
        }
        return n2;
    }

    public static boolean isDecimal(int n, String string) {
        DBType[] dBTypeArray = DBTypeUtil.getDBTypes();
        int[] nArray = new int[]{n, 1};
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            for (int j = 0; j < dBTypeArray.length; ++j) {
                String string2 = dBTypeArray[j].getDBType(n2);
                String string3 = dBTypeArray[j].getDBTypeName(n2);
                if (!string2.equalsIgnoreCase(string) && !string3.equalsIgnoreCase(string) || !dBTypeArray[j].isDecimal()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllowZeroLength(int n, DBType dBType) {
        return n == 16 && (dBType.getTypeGroup() == 15 || dBType.getTypeGroup() == 10);
    }

    public static boolean hasLengthSpecifier(int n, DBType dBType) {
        return dBType.getDBLength(n) != 0;
    }

    static {
        JDBC_TYPE_NAME_MAP.put(new Integer(-7), "BIT");
        JDBC_TYPE_NAME_MAP.put(new Integer(6), "FLOAT");
        JDBC_TYPE_NAME_MAP.put(new Integer(8), "DOUBLE");
        JDBC_TYPE_NAME_MAP.put(new Integer(-6), "TINYINT");
        JDBC_TYPE_NAME_MAP.put(new Integer(5), "SMALLINT");
        JDBC_TYPE_NAME_MAP.put(new Integer(4), "INTEGER");
        JDBC_TYPE_NAME_MAP.put(new Integer(2), "NUMERIC");
        JDBC_TYPE_NAME_MAP.put(new Integer(-5), "BIGINT");
        JDBC_TYPE_NAME_MAP.put(new Integer(91), "DATE");
        JDBC_TYPE_NAME_MAP.put(new Integer(92), "TIME");
        JDBC_TYPE_NAME_MAP.put(new Integer(93), "TIMESTAMP");
        JDBC_TYPE_NAME_MAP.put(new Integer(2004), "BLOB");
        JDBC_TYPE_NAME_MAP.put(new Integer(12), "VARCHAR");
        JDBC_TYPE_NAME_MAP.put(new Integer(2005), "CLOB");
        JDBC_TYPE_NAME_MAP.put(new Integer(-3), "VARBINARY");
        JDBC_TYPE_NAME_MAP.put(new Integer(1), "CHAR");
    }
}

