/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.orm.PersistentException;
import org.orm.PersistentManager;
import org.orm.util.ArraySorter;
import org.orm.util.ORMAdapter;

public abstract class ORMList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ORMList.class);
    private final Object _owner;
    protected final ORMAdapter _ownerAdapter;
    private final int _ownerKey;
    private final int _targetKey;
    private final boolean _biDirectional;
    private final int _collType;

    public ORMList(Object object, ORMAdapter oRMAdapter, int n, int n2, boolean bl, int n3) {
        this._owner = object;
        this._ownerAdapter = oRMAdapter;
        this._ownerKey = n;
        this._targetKey = n2;
        this._biDirectional = bl;
        this._collType = n3;
    }

    protected abstract PersistentManager getPersistentManager() throws PersistentException;

    public List getCollection() {
        try {
            PersistentManager persistentManager = this.getPersistentManager();
            if (persistentManager.getSessionType() == PersistentManager.SessionType.APP_BASE) {
                persistentManager.lockObject(this._owner);
            }
        }
        catch (PersistentException persistentException) {
            log.warn(persistentException);
        }
        return this._ownerAdapter.getList(this._ownerKey);
    }

    protected Iterator getIterator(ORMAdapter oRMAdapter) {
        return this.getCollection().iterator();
    }

    protected void add(Object object, ORMAdapter oRMAdapter) {
        List list = this.getCollection();
        list.add(object);
        this._ownerAdapter.setCollectionCount(this._ownerKey, list.size());
        this.addOpposite(oRMAdapter);
    }

    public void clear() {
        List list = this.getCollection();
        list.clear();
        this._ownerAdapter.setCollectionCount(this._ownerKey, list.size());
    }

    public int size() {
        return this.getCollection().size();
    }

    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    protected void remove(Object object, ORMAdapter oRMAdapter) {
        List list = this.getCollection();
        list.remove(object);
        this._ownerAdapter.setCollectionCount(this._ownerKey, list.size());
        this.removeFromOpposite(oRMAdapter);
    }

    protected boolean contains(Object object) {
        return this.getCollection().contains(object);
    }

    protected Object[] toArray(Object[] objectArray) {
        return this.getCollection().toArray(objectArray);
    }

    protected Object[] toArray(Object[] objectArray, String string, boolean bl) {
        Object[] objectArray2 = this.toArray(objectArray);
        Arrays.sort(objectArray2, new ArraySorter(string, bl));
        return objectArray2;
    }

    protected Object getImpl(int n) {
        return this.getCollection().get(n);
    }

    protected Object removeImpl(int n, ORMAdapter oRMAdapter) {
        List list = this.getCollection();
        Object e = list.remove(n);
        this._ownerAdapter.setCollectionCount(this._ownerKey, list.size());
        this.removeFromOpposite(oRMAdapter);
        return e;
    }

    protected void add(int n, Object object, ORMAdapter oRMAdapter) {
        List list = this.getCollection();
        list.add(n, object);
        this._ownerAdapter.setCollectionCount(this._ownerKey, list.size());
        this.addOpposite(oRMAdapter);
    }

    protected int indexOf(Object object) {
        return this.getCollection().indexOf(object);
    }

    protected Object set(int n, Object object) {
        return this.getCollection().set(n, object);
    }

    private void removeFromOpposite(ORMAdapter oRMAdapter) {
        if (oRMAdapter != null) {
            List list;
            if (this._collType == 1) {
                oRMAdapter.setOwner(null, this._targetKey);
            } else if (this._collType == 2 && (list = oRMAdapter.getList(this._targetKey)) != null) {
                list.remove(this._owner);
                oRMAdapter.setCollectionCount(this._targetKey, list.size());
            }
        }
    }

    private void addOpposite(ORMAdapter oRMAdapter) {
        if (oRMAdapter != null) {
            List list;
            if (this._collType == 1) {
                oRMAdapter.setOwner(this._owner, this._targetKey);
            } else if (this._collType == 2 && (list = oRMAdapter.getList(this._targetKey)) != null) {
                list.add(this._owner);
                oRMAdapter.setCollectionCount(this._targetKey, list.size());
            }
        }
    }
}

