/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.orm.PersistentException;
import org.orm.PersistentManager;
import org.orm.util.ArraySorter;
import org.orm.util.ORMAdapter;

public abstract class ORMMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ORMMap.class);
    private final Object _owner;
    protected final ORMAdapter _ownerAdapter;
    private final int _ownerKey;
    private final int _targetKey;
    private final boolean _biDirectional;
    private final int _collType;

    public ORMMap(Object object, ORMAdapter oRMAdapter, int n, int n2, boolean bl, int n3) {
        this._owner = object;
        this._ownerAdapter = oRMAdapter;
        this._ownerKey = n;
        this._targetKey = n2;
        this._biDirectional = bl;
        this._collType = n3;
    }

    protected abstract PersistentManager getPersistentManager() throws PersistentException;

    public Map getCollection() {
        try {
            PersistentManager persistentManager = this.getPersistentManager();
            if (persistentManager.getSessionType() == PersistentManager.SessionType.APP_BASE) {
                persistentManager.lockObject(this._owner);
            }
        }
        catch (PersistentException persistentException) {
            log.warn(persistentException);
        }
        return this._ownerAdapter.getMap(this._ownerKey);
    }

    protected Iterator getIterator(ORMAdapter oRMAdapter) {
        return this.getCollection().values().iterator();
    }

    protected void add(Object object, Object object2, ORMAdapter oRMAdapter) {
        this.getCollection().put(object, object2);
        if (oRMAdapter != null && this._collType == 1) {
            oRMAdapter.setOwner(this._owner, this._targetKey);
        }
    }

    public void clear() {
        this.getCollection().clear();
    }

    public int size() {
        return this.getCollection().size();
    }

    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    protected void remove(Object object, ORMAdapter oRMAdapter) {
        this.getCollection().remove(object);
        if (oRMAdapter != null && this._collType == 1) {
            oRMAdapter.setOwner(null, this._targetKey);
        }
    }

    protected boolean contains(Object object) {
        return this.getCollection().containsKey(object);
    }

    protected Object getImpl(Object object) {
        return this.getCollection().get(object);
    }

    protected Iterator getKeyIterator() {
        return this.getCollection().keySet().iterator();
    }

    protected Object[] toArray(Object[] objectArray) {
        return this.getCollection().values().toArray(objectArray);
    }

    protected Object[] toArray(Object[] objectArray, String string, boolean bl) {
        Object[] objectArray2 = this.toArray(objectArray);
        Arrays.sort(objectArray2, new ArraySorter(string, bl));
        return objectArray2;
    }
}

