/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.orm.PersistentException;
import org.orm.PersistentManager;
import org.orm.util.ArraySorter;
import org.orm.util.ORMAdapter;

public abstract class ORMSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ORMSet.class);
    private final Object _owner;
    protected final ORMAdapter _ownerAdapter;
    private final int _ownerKey;
    private final int _targetKey;
    private final boolean _biDirectional;
    private final int _collType;

    public ORMSet(Object object, ORMAdapter oRMAdapter, int n, int n2, boolean bl, int n3) {
        this._owner = object;
        this._ownerAdapter = oRMAdapter;
        this._ownerKey = n;
        this._targetKey = n2;
        this._biDirectional = bl;
        this._collType = n3;
    }

    protected abstract PersistentManager getPersistentManager() throws PersistentException;

    public Set getCollection() {
        try {
            PersistentManager persistentManager = this.getPersistentManager();
            if (persistentManager.getSessionType() == PersistentManager.SessionType.APP_BASE) {
                persistentManager.lockObject(this._owner);
            }
        }
        catch (PersistentException persistentException) {
            log.warn(persistentException);
        }
        return this._ownerAdapter.getSet(this._ownerKey);
    }

    protected Iterator getIterator(ORMAdapter oRMAdapter) {
        return this.getCollection().iterator();
    }

    protected void add(Object object, ORMAdapter oRMAdapter) {
        Set set = this.getCollection();
        set.add(object);
        this._ownerAdapter.setCollectionCount(this._ownerKey, set.size());
        if (oRMAdapter != null) {
            Set set2;
            if (this._collType == 1) {
                oRMAdapter.setOwner(this._owner, this._targetKey);
            } else if (this._collType == 2 && (set2 = oRMAdapter.getSet(this._targetKey)) != null) {
                set2.add(this._owner);
                oRMAdapter.setCollectionCount(this._targetKey, set2.size());
            }
        }
    }

    public void clear() {
        this.getCollection().clear();
        this._ownerAdapter.setCollectionCount(this._ownerKey, 0);
    }

    public int size() {
        return this.getCollection().size();
    }

    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    protected void remove(Object object, ORMAdapter oRMAdapter) {
        Set set = this.getCollection();
        set.remove(object);
        this._ownerAdapter.setCollectionCount(this._ownerKey, set.size());
        if (oRMAdapter != null) {
            Set set2;
            if (this._collType == 1) {
                oRMAdapter.setOwner(null, this._targetKey);
            } else if (this._collType == 2 && (set2 = oRMAdapter.getSet(this._targetKey)) != null) {
                set2.remove(this._owner);
                oRMAdapter.setCollectionCount(this._targetKey, set2.size());
            }
        }
    }

    protected boolean contains(Object object) {
        return this.getCollection().contains(object);
    }

    protected Object[] toArray(Object[] objectArray) {
        return this.getCollection().toArray(objectArray);
    }

    protected Object[] toArray(Object[] objectArray, String string, boolean bl) {
        Object[] objectArray2 = this.toArray(objectArray);
        Arrays.sort(objectArray2, new ArraySorter(string, bl));
        return objectArray2;
    }
}

