/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import java.util.Hashtable;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.orm.PersistentException;
import org.orm.PersistentSession;
import org.orm.util.ORMSessionFactory;
import org.orm.util.SessionController;

public class ThreadBaseSessionController
implements SessionController {
    private ORMSessionFactory _sessionFactory = null;
    private Hashtable _sessions;

    public ThreadBaseSessionController(Configuration configuration) throws PersistentException {
        try {
            this._sessionFactory = new ORMSessionFactory(configuration);
            this._sessions = new Hashtable();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException("Failed to create ThreadBaseSessionController", hibernateException);
        }
    }

    public PersistentSession getSession() throws PersistentException {
        return this.getSession(true);
    }

    public synchronized PersistentSession getSession(boolean bl) throws PersistentException {
        try {
            Object v = this._sessions.get(Thread.currentThread());
            if (v != null) {
                PersistentSession persistentSession = (PersistentSession)v;
                if (!persistentSession.isOpen()) {
                    if (bl) {
                        persistentSession = new PersistentSession(this._sessionFactory.createSession(), this._sessionFactory.getCfg());
                        this._sessions.put(Thread.currentThread(), persistentSession);
                    } else {
                        this._sessions.remove(Thread.currentThread());
                        persistentSession = null;
                    }
                }
                return persistentSession;
            }
            if (bl) {
                PersistentSession persistentSession = new PersistentSession(this._sessionFactory.createSession(), this._sessionFactory.getCfg());
                this._sessions.put(Thread.currentThread(), persistentSession);
                return persistentSession;
            }
            return null;
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException("Failed to create PersistentSession", hibernateException);
        }
    }

    public void disposeSession() throws PersistentException {
        for (PersistentSession persistentSession : this._sessions.values()) {
            if (persistentSession == null || !persistentSession.isOpen()) continue;
            persistentSession.close();
        }
        this._sessions.clear();
        this._sessionFactory.close();
    }
}

