/*
 * Decompiled with CFR 0.152.
 */
package org.orm.util;

import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.orm.PersistentException;
import org.orm.PersistentSession;
import org.orm.util.ORMSessionFactory;
import org.orm.util.SessionController;

public class UserDefinedSessionController
implements SessionController {
    private ORMSessionFactory _sessionFactory = null;
    private Vector _sessions;

    public UserDefinedSessionController(Configuration configuration) throws PersistentException {
        try {
            this._sessionFactory = new ORMSessionFactory(configuration);
            this._sessions = new Vector();
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException("Failed to create UserDefinedSessionController", hibernateException);
        }
    }

    public PersistentSession getSession() throws PersistentException {
        return this.getSession(true);
    }

    public PersistentSession getSession(boolean bl) throws PersistentException {
        try {
            PersistentSession persistentSession = new PersistentSession(this._sessionFactory.createSession(), this._sessionFactory.getCfg());
            this._sessions.add(persistentSession);
            return persistentSession;
        }
        catch (HibernateException hibernateException) {
            throw new PersistentException("Failed to create PersistentSession", hibernateException);
        }
    }

    public void disposeSession() throws PersistentException {
        for (PersistentSession persistentSession : this._sessions) {
            if (persistentSession == null || !persistentSession.isOpen()) continue;
            persistentSession.close();
        }
        this._sessions.clear();
        this._sessionFactory.close();
    }
}

