/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf;

/**
 * Interface describing a pluggable look and feel patch. 
 * @author Brian.Duff@oracle.com
 */
public interface LookAndFeelPatch 
{
  /**
   * Is this patch applicable to the environment?
   * 
   * @return true if this patch is applicable to the specified environment.
   */
  boolean isApplicable( Environment env );
  
  /**
   * Install the patch.
   */
  void patch( Environment env );
  
  /**
   * Deinstall the patch, if possible & necessary.
   */
  void unpatch( );
}