/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Gerhard Leonhartsberger. Portions created by 
	Gerhard Leonhartsberger are Copyright(C) Gerhard Leonhartsberger. 
	All Rights Reserved.

	Contributor(s): ___________________________.
*/
package net.java.plaf.test;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;

import javax.swing.JComboBox;
import javax.swing.JPanel;

/**
 * 
 */
public class ComboBoxMarginPatchTestModule extends PatchTestModule {

	public ComboBoxMarginPatchTestModule() {
		super("Combo Box Margin Patch");
	}

	protected void createPatchTestPane(Container contentPane) {
		
		JPanel panel = new JPanel(new FlowLayout());
		
		String[] items = { "First", "Second", "Third", "What's next?" };
		JComboBox cb = new JComboBox(items);
		panel.add(cb);
		contentPane.add(panel, BorderLayout.CENTER);
	}

	public String getIssueDescription() {
		return "Issue 5: Insets on non-editable JComboBox are wrong";
	}
}
