/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Gerhard Leonhartsberger. Portions created by 
	Gerhard Leonhartsberger are Copyright(C) Gerhard Leonhartsberger. 
	All Rights Reserved.

	Contributor(s): ___________________________.
*/
package net.java.plaf.test;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JList;
import javax.swing.JScrollPane;

import net.java.plaf.windows.xp.DefaultListCellRenderer;

public class ListSelectionPatchTestModule extends PatchTestModule {

	public ListSelectionPatchTestModule() {
		super("List Selection Patch");
	}

	protected void createPatchTestPane(Container contentPane) {

		String[] items = { "Swing", "is", "cool", "and", "WinLaF", "too" };
		JList list = new JList(items);
		list.setCellRenderer(new DefaultListCellRenderer());
		contentPane.add(new JScrollPane(list), BorderLayout.CENTER);
	}

	/* (non-Javadoc)
	 * @see net.java.plaf.test.PatchTestModule#getIssueDescription()
	 */
	public String getIssueDescription() {
		return "Issue 28: JList does not update selection when loosing focus to non-focus selection color.";
	}

}
