/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Gerhard Leonhartsberger. Portions created by 
	Gerhard Leonhartsberger are Copyright(C) Gerhard Leonhartsberger. 
	All Rights Reserved.

	Contributor(s): ___________________________.
*/
package net.java.plaf.test;

import java.awt.BorderLayout;
import java.awt.Container;

import java.util.List;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;


public class PatchTestModule implements IPatchTestModule {

	private String patchName;
	private JPanel contentPane;
	protected List patchTestModuleList;
	
	public PatchTestModule(String patchName) {
		
		this.patchName = patchName;
		patchTestModuleList = new Vector();
		
		createUI();
	}

	protected void createUI() {
		
		contentPane = new JPanel(new BorderLayout( 0, 15 ));
		contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		createIssuePane(contentPane);
		createPatchTestPane(contentPane);
	}

	protected void createIssuePane(Container contentPane) {
		JLabel issueHint = new JLabel();

		issueHint.setText( "<html><p>"+getIssueDescription()+"</p></html>" );
		contentPane.add( issueHint , BorderLayout.NORTH);
	}

	protected void createPatchTestPane(Container contentPane) {
	}

	/* (non-Javadoc)
	 * @see net.java.plaf.test.IPatchTestModule#getPatchName()
	 */
	public String getPatchName() {
		return patchName;
	}

	public Container getContentPane() {
		return contentPane;
	}
	
	public int getSubPatchTestModuleCount() {
		return patchTestModuleList.size();
	}
	
	public IPatchTestModule getSubPatchTestModuleAt(int index) {
		return (IPatchTestModule)patchTestModuleList.get(index);
	}
	
	public int getIndexOf(IPatchTestModule module) {
		return patchTestModuleList.indexOf(module);
	}
	
	public String toString() {
		return getPatchName();
	}
	
	protected void addSubPatchTestModule(IPatchTestModule module) {
		patchTestModuleList.add(module);
	}
	
	/* (non-Javadoc)
	 * @see net.java.plaf.test.IPatchTestModule#getIssueDescription()
	 */
	public String getIssueDescription() {
		return "Patch Test Module";
	}

}
