/*
 *  ------------------------------------------------------------------------
 *  Copyright (C) Software Competence Center Hagenberg (SCCH) GmbH
 *                All rights reserved.
 *  ------------------------------------------------------------------------
 *  Copyright (C) COMNEON Software GmbH	& Co. OHG. All rights reserved.
 *  ------------------------------------------------------------------------
 *  This document contains proprietary information belonging to	COMNEON
 *  Software GmbH & Co. OHG and SCCH GmbH.
 *  Passing	on and copying of this document, use and communication of its
 *  contents is	not	permitted without prior	written	authorisation.
 *  ------------------------------------------------------------------------
 *  Created on Sep 17, 2003 by leonhartsberger
 */
package net.java.plaf.test;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;

/**
 * @author leonhartsberger
 * @version $Revision: 1.1 $
 */
public class ScrollBarPatchTestModule extends PatchTestModule {

    public ScrollBarPatchTestModule() {
        super("Scroll bars");
    }
    
    protected void createPatchTestPane(Container contentPane) {

        JScrollBar horizontalScrollBar1 = new JScrollBar(JScrollBar.HORIZONTAL);
        JScrollBar horizontalScrollBar2 = new JScrollBar(JScrollBar.HORIZONTAL);
        JScrollBar verticalScrollBar1 = new JScrollBar(JScrollBar.VERTICAL);
        JScrollBar verticalScrollBar2 = new JScrollBar(JScrollBar.VERTICAL);
        JLabel label = new JLabel("Right-click a scroll bar!");
        label.setHorizontalAlignment(SwingConstants.CENTER);

        JPanel panel = new JPanel(new BorderLayout());
        panel.add(horizontalScrollBar1, BorderLayout.SOUTH);
        panel.add(horizontalScrollBar2, BorderLayout.NORTH);
        panel.add(verticalScrollBar1, BorderLayout.EAST);
        panel.add(verticalScrollBar2, BorderLayout.WEST);
        panel.add(label, BorderLayout.CENTER);
        
        contentPane.add(panel, BorderLayout.CENTER);
    }
    
    public String getIssueDescription() {
        return "<b>Issue 2:</b> Scrollbar in Windows has context menu, doesn't in Java.<br>";
    }    
}
