/*
  The contents of this file are subject to the Sun Public License
	Version 1.0 (the "License"); you may not use this file except in
	compliance with the License. A copy of the License is available at
	http://www.sun.com/

	The Original Code is winlaf. The Initial Developer of the
	Original Code is Brian Duff. Portions created by Brian Duff are Copyright
	(C)Brian Duff. All Rights Reserved.

	Contributor(s): ______________________________________.
*/

package net.java.plaf.windows.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

/**
 * Layout manager that lays its items out like flow layout, but without
 * wrapping, with a minimum width and ensuring all items have the same width.
 * 
 * @author Brian.Duff@oracle.com
 */
class ButtonBarLayout implements LayoutManager
{
  private final int m_minWidth;
  private final int m_padding;

  ButtonBarLayout( int minWidth, int padding )
  {
    m_minWidth = minWidth;
    m_padding = padding;
  }
  

	public void addLayoutComponent(String string, Component comp) 
  {
	}  
  
  public void removeLayoutComponent( Component component )
  {
    
  }
  
  private int[] calculateMaxWidthAndHeight( Component[] children )
  {
    int maxWidth = 0;
    int maxHeight = 0;   
    int[] result = new int[ 2 ];
    
    for ( int i = 0; i < children.length; i++ )
    {
      Component c = children[ i ];
      Dimension prefSize = c.getPreferredSize();
      maxWidth = Math.max( maxWidth, Math.max( m_minWidth, prefSize.width ) );
      maxHeight = Math.max( maxHeight, prefSize.height );
    }
    
    result[ 0 ] = maxWidth;
    result[ 1 ] = maxHeight;
  
    return result;
  }

  
	public Dimension minimumLayoutSize( Container container ) 
  {
    Component[] children = container.getComponents();
    Insets containerInsets = container.getInsets();
    
    if ( children != null && children.length > 0 )
    {
      int[] wandh = calculateMaxWidthAndHeight( children );
      int maxWidth = wandh[ 0 ];
      int maxHeight = wandh[ 1 ];
      
      int totalWidth = 
        ( maxWidth * children.length ) +
        ( m_padding * children.length - 1 ) +
        containerInsets.left + 
        containerInsets.right;
      
      return new Dimension( totalWidth, 
        maxHeight + containerInsets.top + containerInsets.bottom );
    }
    else
    {
      return new Dimension( containerInsets.left + containerInsets.right, 
        containerInsets.top + containerInsets.bottom );
    }
  }  
  
  public Dimension preferredLayoutSize( Container container )
  {
    return minimumLayoutSize( container );
  }
  
	public void layoutContainer(Container container) 
  {
    Component[] children = container.getComponents();
    
    int numChildren = children.length;
    
    if( children != null && numChildren > 0 ) 
    {
      int[] wandh = calculateMaxWidthAndHeight( children );
      int maxWidth = wandh[ 0 ];
//      int maxHeight = wandh[ 1 ];
      Insets insets = container.getInsets();
      
      int yLocation = insets.top;
			int xLocation = (container.getSize().width - insets.left - insets.right -
					  (maxWidth * numChildren +
					   (numChildren - 1) * m_padding)) / 2;
			int xOffset = m_padding + maxWidth;
      
      if ( !container.getComponentOrientation().isLeftToRight() )
      {
        xLocation = container.getSize().width - insets.right
                    - (xLocation - insets.left) - maxWidth;
        xOffset = -xOffset;        
      }
      
		  for( int counter = 0; counter < numChildren; counter++) 
      {
        children[counter].setBounds(xLocation, yLocation,
						    maxWidth,
						    children[counter].getPreferredSize().height);
        xLocation += xOffset;
		  }      
    }
  }


}